/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.message;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.common.model.message.MessageBody;
import cn.jmessage.api.common.model.message.Notification;
import cn.jmessage.api.message.MessageType;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class MessagePayload
implements IModel {
    private static final String VERSION = "version";
    private static final String TARGET_TYPE = "target_type";
    private static final String FROM_TYPE = "from_type";
    private static final String MSG_TYPE = "msg_type";
    private static final String TARGET_ID = "target_id";
    private static final String FROM_ID = "from_id";
    private static final String MSG_BODY = "msg_body";
    private static final String NO_OFFLINE = "no_offline";
    private static final String NO_NOTIFICATION = "no_notification";
    private static final String NOTIFICATION = "notification";
    private static Gson gson = new Gson();
    private Integer version;
    private String target_type;
    private String target_id;
    private String from_type;
    private String from_id;
    private MessageType msg_type;
    private MessageBody msg_body;
    private Notification notification;

    public MessagePayload(Integer version, String target_type, String target_id, String from_type, String from_id, MessageType msg_type, MessageBody msg_body, Notification notification) {
        this.version = version;
        this.target_type = target_type;
        this.target_id = target_id;
        this.from_type = from_type;
        this.from_id = from_id;
        this.msg_type = msg_type;
        this.msg_body = msg_body;
        this.notification = notification;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.version) {
            json.addProperty(VERSION, (Number)this.version);
        }
        if (null != this.target_type) {
            json.addProperty(TARGET_TYPE, this.target_type);
        }
        if (null != this.target_id) {
            json.addProperty(TARGET_ID, this.target_id);
        }
        if (null != this.from_type) {
            json.addProperty(FROM_TYPE, this.from_type);
        }
        if (null != this.from_id) {
            json.addProperty(FROM_ID, this.from_id);
        }
        if (null != this.msg_type) {
            json.addProperty(MSG_TYPE, this.msg_type.getValue());
        }
        if (null != this.msg_body) {
            json.add(MSG_BODY, this.msg_body.toJSON());
        }
        if (null != this.notification) {
            json.add(NOTIFICATION, this.notification.toJSON());
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private Integer version;
        private String target_type;
        private String target_id;
        private String from_type;
        private String from_id;
        private MessageType msg_type;
        private MessageBody msg_body;
        private Notification notification;

        public Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        public Builder setTargetType(String target_type) {
            this.target_type = target_type.trim();
            return this;
        }

        public Builder setTargetId(String target_id) {
            this.target_id = target_id.trim();
            return this;
        }

        public Builder setFromType(String from_type) {
            this.from_type = from_type.trim();
            return this;
        }

        public Builder setFromId(String from_id) {
            this.from_id = from_id.trim();
            return this;
        }

        public Builder setMessageType(MessageType msg_type) {
            this.msg_type = msg_type;
            return this;
        }

        public Builder setMessageBody(MessageBody msg_body) {
            this.msg_body = msg_body;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public MessagePayload build() {
            Preconditions.checkArgument((null != this.version ? 1 : 0) != 0, (Object)"The version must not be empty!");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(this.target_type), (Object)"The target type must not be empty!");
            StringUtils.checkUsername(this.target_id);
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(this.from_type), (Object)"The from type must not be empty!");
            StringUtils.checkUsername(this.from_id);
            Preconditions.checkArgument((this.msg_type != null ? 1 : 0) != 0, (Object)"The message type must not be empty!");
            Preconditions.checkArgument((null != this.msg_body ? 1 : 0) != 0, (Object)"The message body must not be empty!");
            return new MessagePayload(this.version, this.target_type, this.target_id, this.from_type, this.from_id, this.msg_type, this.msg_body, this.notification);
        }
    }
}

