/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class UserPayload
implements IModel {
    public static final String NICKNAME = "nickname";
    public static final String BIRTHDAY = "birthday";
    public static final String SIGNATURE = "signature";
    public static final String GENDER = "gender";
    public static final String REGION = "region";
    public static final String ADDRESS = "address";
    public static final String AVATAR = "avatar";
    private static Gson _gson = new Gson();
    private String nickname;
    private String birthday;
    private String signature;
    private int gender;
    private String region;
    private String address;
    private String avatar;

    private UserPayload(String nickname, String birthday, String signature, int gender, String region, String address, String avatar) {
        this.nickname = nickname;
        this.birthday = birthday;
        this.signature = signature;
        this.gender = gender;
        this.region = region;
        this.address = address;
        this.avatar = avatar;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.nickname) {
            json.addProperty(NICKNAME, this.nickname);
        }
        if (null != this.birthday) {
            json.addProperty(BIRTHDAY, this.birthday);
        }
        if (-1 != this.gender) {
            json.addProperty(GENDER, (Number)this.gender);
        }
        if (null != this.signature) {
            json.addProperty(SIGNATURE, this.signature);
        }
        if (null != this.region) {
            json.addProperty(REGION, this.region);
        }
        if (null != this.address) {
            json.addProperty(ADDRESS, this.address);
        }
        if (null != this.avatar) {
            json.addProperty(AVATAR, this.avatar);
        }
        return json;
    }

    public String toString() {
        return _gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String nickname;
        private String birthday;
        private String signature;
        private int gender = -1;
        private String region;
        private String address;
        private String avatar;

        public Builder setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder setBirthday(String birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setGender(int gender) {
            this.gender = gender;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setAvatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public UserPayload build() {
            if (null != this.nickname) {
                Preconditions.checkArgument((this.nickname.getBytes().length <= 64 ? 1 : 0) != 0, (Object)"The length of nickname must less than 64 bytes.");
                Preconditions.checkArgument((!StringUtils.isLineBroken((String)this.nickname) ? 1 : 0) != 0, (Object)"The nickname must not contain line feed character.");
            }
            if (null != this.birthday) {
                Preconditions.checkArgument((boolean)ServiceHelper.isValidBirthday((String)this.birthday), (Object)"Invalid birthday.");
            }
            if (null != this.signature) {
                Preconditions.checkArgument((this.signature.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of signature must not more than 250 bytes.");
            }
            Preconditions.checkArgument((this.gender >= -1 && this.gender <= 2 ? 1 : 0) != 0, (Object)"Invalid gender. 0 for unknown , 1 for male and 2 for female.");
            if (null != this.region) {
                Preconditions.checkArgument((this.region.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of region must not more than 250 bytes.");
            }
            if (null != this.address) {
                Preconditions.checkArgument((this.address.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of address must not more than 250 bytes.");
            }
            return new UserPayload(this.nickname, this.birthday, this.signature, this.gender, this.region, this.address, this.avatar);
        }
    }
}

