/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class RegisterInfo
implements IModel {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String NICKNAME = "nickname";
    private static final String AVATAR = "avatar";
    private static final String BIRTHDAY = "birthday";
    private static final String SIGNATURE = "signature";
    private static final String GENDER = "gender";
    private static final String REGION = "region";
    private static final String ADDRESS = "address";
    private static Gson gson = new Gson();
    private String username;
    private String password;
    private String nickname;
    private String avatar;
    private String birthday;
    private String signature;
    private int gender = -1;
    private String region;
    private String address;

    private RegisterInfo(String username, String password, String nickname, String avatar, String birthday, String signature, int gender, String region, String address) {
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.avatar = avatar;
        this.birthday = birthday;
        this.signature = signature;
        this.gender = gender;
        this.region = region;
        this.address = address;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.username) {
            json.addProperty(USERNAME, this.username);
        }
        if (null != this.password) {
            json.addProperty(PASSWORD, this.password);
        }
        if (null != this.nickname) {
            json.addProperty(NICKNAME, this.nickname);
        }
        if (null != this.avatar) {
            json.addProperty(AVATAR, this.avatar);
        }
        if (null != this.birthday) {
            json.addProperty(BIRTHDAY, this.birthday);
        }
        if (null != this.signature) {
            json.addProperty(SIGNATURE, this.signature);
        }
        if (this.gender != -1) {
            json.addProperty(GENDER, (Number)this.gender);
        }
        if (null != this.region) {
            json.addProperty(REGION, this.region);
        }
        if (null != this.address) {
            json.addProperty(ADDRESS, this.address);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String username;
        private String password;
        private String nickname;
        private String avatar;
        private String birthday;
        private String signature;
        private int gender = -1;
        private String region;
        private String address;

        public Builder setUsername(String username) {
            this.username = username.trim();
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password.trim();
            return this;
        }

        public Builder setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder setAvatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder setBirthday(String birthday) {
            Preconditions.checkArgument((boolean)this.isDateFormat(birthday), (Object)"Birthday format must be yyyy-MM-dd");
            this.birthday = birthday;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setGender(int gender) {
            Preconditions.checkArgument((gender == 0 || gender == 1 || gender == 2 ? 1 : 0) != 0, (Object)"Gender must be 0, or 1, or 2");
            this.gender = gender;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public RegisterInfo build() {
            StringUtils.checkUsername(this.username);
            StringUtils.checkPassword(this.password);
            return new RegisterInfo(this.username, this.password, this.nickname, this.avatar, this.birthday, this.signature, this.gender, this.region, this.address);
        }

        private boolean isDateFormat(String date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                sdf.parse(date);
                return true;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

