/*
 * Decompiled with CFR 0.152.
 */
package cn.howardliu.gear.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerFactory<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaProducerFactory.class);
    private Properties config = new Properties();

    public KafkaProducerFactory(Properties config) {
        this.config.put("bootstrap.servers", "127.0.0.1:9092");
        this.config.put("acks", "all");
        this.config.put("buffer.memory", "33554432");
        this.config.put("compression.type", "none");
        this.config.put("retries", "0");
        this.config.put("batch.size", "16384");
        this.config.put("client.id", "default-client-id");
        this.config.put("linger.ms", "0");
        this.config.put("max.request.size", "1048576");
        this.config.put("receive.buffer.bytes", "32768");
        this.config.put("send.buffer.bytes", "131072");
        this.config.put("timeout.ms", "30000");
        this.config.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.config.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.config.putAll((Map<?, ?>)((Map)Validate.notNull((Object)config, (String)"the configuration object mustn't null", (Object[])new Object[0])));
        logger.debug("the configuration of consumer is {}", (Object)this.config);
    }

    public KafkaProducerFactory(String bootstrapServers) {
        this.config.put("bootstrap.servers", "127.0.0.1:9092");
        this.config.put("acks", "all");
        this.config.put("buffer.memory", "33554432");
        this.config.put("compression.type", "none");
        this.config.put("retries", "0");
        this.config.put("batch.size", "16384");
        this.config.put("client.id", "default-client-id");
        this.config.put("linger.ms", "0");
        this.config.put("max.request.size", "1048576");
        this.config.put("receive.buffer.bytes", "32768");
        this.config.put("send.buffer.bytes", "131072");
        this.config.put("timeout.ms", "30000");
        this.config.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.config.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.config.setProperty("bootstrap.servers", (String)Validate.notEmpty((CharSequence)bootstrapServers, (String)"the bootstrap servers mustn't null", (Object[])new Object[0]));
    }

    public KafkaProducer<K, V> build() {
        return new KafkaProducer(this.config);
    }
}

