/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import cn.dreampie.common.model.User;
import cn.dreampie.common.util.ValidateUtils;
import cn.dreampie.common.util.security.EncriptionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectUtils {
    private static SubjectUtils subjectUtils = new SubjectUtils();
    private static String[] baseRole = new String[]{"R_ADMIN", "R_MANAGER", "R_MEMBER", "R_USER"};

    private SubjectUtils() {
    }

    public static SubjectUtils me() {
        return subjectUtils;
    }

    public Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public Session getSession() {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        if (session == null) {
            throw new UnknownSessionException("Unable found required Session");
        }
        return session;
    }

    public <T extends User> T getUser() {
        Session session = this.getSession();
        Object user = this.getSubject().getPrincipals().getPrimaryPrincipal();
        if (ValidateUtils.me().isNullOrEmpty(user)) {
            return null;
        }
        User u = (User)((Object)user);
        u.remove(new String[]{"password", "hasher", "salt"});
        u.removeNullValueAttrs();
        return (T)((Object)((User)((Object)user)));
    }

    public <T extends User> boolean login(String username, String password, T user) {
        return this.login(username, password, false, user);
    }

    public <T extends User> boolean login(String username, String password, boolean rememberMe, T user) {
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            token.setRememberMe(rememberMe);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public boolean doCaptcha(String captchaToken) {
        Session session = this.getSession();
        if (session.getAttribute((Object)"captcha") != null) {
            String captcha = session.getAttribute((Object)"captcha").toString();
            if (captchaToken != null && captcha.equalsIgnoreCase(EncriptionUtils.encrypt(captchaToken))) {
                return true;
            }
        }
        return false;
    }

    public boolean wasLogin() {
        Subject subject = this.getSubject();
        return subject != null && subject.getPrincipal() != null && subject.isAuthenticated();
    }

    public boolean wasBaseRole(String roleValue) {
        return ArrayUtils.contains((Object[])baseRole, (Object)roleValue);
    }

    public static String[] getBaseRole() {
        return baseRole;
    }

    public static void setBaseRole(String[] baseRole) {
        SubjectUtils.baseRole = baseRole;
    }
}

