/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.util;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertiesUtils {
    private ConcurrentMap<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private static PropertiesUtils propertiesUtils = new PropertiesUtils();

    private PropertiesUtils() {
    }

    public static PropertiesUtils me() {
        return propertiesUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyFile(String file) {
        Properties properties = new Properties();
        if (StrKit.isBlank((String)file)) {
            throw new IllegalArgumentException("Parameter of file can not be blank");
        }
        if (file.contains("..")) {
            throw new IllegalArgumentException("Parameter of file can not contains \"..\"");
        }
        InputStream inputStream = null;
        boolean startStuff = file.startsWith(File.separator);
        String fullFile = startStuff ? PathKit.getWebRootPath() + File.separator + "WEB-INF" + file : PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + file;
        File propFile = new File(fullFile);
        if (!propFile.exists() && !(propFile = new File(fullFile = startStuff ? PathKit.getRootClassPath() + file : PathKit.getRootClassPath() + File.separator + file)).exists()) {
            throw new IllegalArgumentException("Properties file not found: " + fullFile);
        }
        try {
            inputStream = new FileInputStream(new File(fullFile));
            properties.load(inputStream);
        }
        catch (Exception eOne) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                properties.load(loader.getResourceAsStream(file));
            }
            catch (IOException eTwo) {
                throw new IllegalArgumentException("Properties file loading failed: " + eTwo.getMessage());
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.properties.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return properties;
    }

    public String getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key).toString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key).toString();
        }
        return defaultValue;
    }

    public Integer getPropertyToInt(String key) {
        Integer resultInt = null;
        String resultStr = this.getProperty(key);
        if (resultStr != null) {
            resultInt = Integer.parseInt(resultStr);
        }
        return resultInt;
    }

    public Integer getPropertyToInt(String key, Integer defaultValue) {
        Integer result = this.getPropertyToInt(key);
        return result != null ? result : defaultValue;
    }

    public Boolean getPropertyToBoolean(String key) {
        String resultStr = this.getProperty(key);
        Boolean resultBool = null;
        if (resultStr != null) {
            if (resultStr.trim().equalsIgnoreCase("true")) {
                resultBool = true;
            } else if (resultStr.trim().equalsIgnoreCase("false")) {
                resultBool = false;
            }
        }
        return resultBool;
    }

    public Boolean getPropertyToBoolean(String key, boolean defaultValue) {
        Boolean result = this.getPropertyToBoolean(key);
        return result != null ? result : defaultValue;
    }
}

