/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.tablebind;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSearcherExt {
    protected static final Logger LOG = Logger.getLogger(ClassSearcherExt.class);
    private List<String> includepaths = Lists.newArrayList();
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList classList = Lists.newArrayList();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on((String)classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearcherExt of(Class target) {
        return new ClassSearcherExt(target);
    }

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        List<Object> classFiles = Lists.newArrayList();
        URL baseURL = ClassSearcherExt.class.getResource(File.separator + baseDirName.replaceAll("\\.", "/"));
        if (baseURL != null) {
            String protocol = baseURL.getProtocol();
            String basePath = baseURL.getFile();
            if ("jar".equals(protocol)) {
                String[] paths = basePath.split("!/");
                try {
                    classFiles = ClassSearcherExt.findJarFile(paths[0].replace("file:", ""), paths[1]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                classFiles = ClassSearcherExt.findPathFiles(basePath, targetFileName);
            }
        }
        return classFiles;
    }

    private static List<String> findPathFiles(String baseDirName, String targetFileName) {
        ArrayList classFiles = Lists.newArrayList();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            String classname = null;
            String tem = null;
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassSearcherExt.findPathFiles(baseDirName + File.separator + filelist[i], targetFileName));
                    continue;
                }
                tempName = readfile.getName();
                if (!ClassSearcherExt.wildcardMatch(targetFileName, tempName)) continue;
                tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                classname = tem.substring(tem.indexOf("/classes") + "/classes".length() + 1, tem.indexOf(".class"));
                classFiles.add(classname.replaceAll("/", "."));
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcherExt.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public ClassSearcherExt(Class target) {
        this.target = target;
    }

    public ClassSearcherExt includepaths(String ... classpaths) {
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.includepaths.add(classpath);
            }
        }
        return this;
    }

    public ClassSearcherExt includepaths(List<String> classpaths) {
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.includepaths.add(classpath);
            }
        }
        return this;
    }

    public <T> List<Class<? extends T>> search() {
        if (this.includepaths.size() <= 0) {
            List<String> classFileList = ClassSearcherExt.findPathFiles(this.getClass().getResource(File.separator).getPath(), "*.class");
            return ClassSearcherExt.extraction(this.target, classFileList);
        }
        ArrayList classFileList = Lists.newArrayList();
        for (String classpath : this.includepaths) {
            classFileList.addAll(ClassSearcherExt.findFiles(classpath, "*.class"));
        }
        return ClassSearcherExt.extraction(this.target, classFileList);
    }

    private List<String> findjarFiles(String baseDirName, final List<String> includeJars, String packageName) {
        ArrayList classFiles = Lists.newArrayList();
        try {
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                LOG.error("file serach error\uff1a" + baseDirName + " is not a dir\uff01");
            } else {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return includeJars.contains(name);
                    }
                });
                for (int i = 0; i < filelist.length; ++i) {
                    classFiles.addAll(ClassSearcherExt.findJarFile(baseDirName + File.separator + filelist[i], packageName));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    private static List<String> findJarFile(String filePath, String packageName) throws IOException {
        List<Object> classFiles = Lists.newArrayList();
        JarFile localJarFile = new JarFile(new File(filePath));
        classFiles = ClassSearcherExt.findInJar(localJarFile, packageName);
        localJarFile.close();
        return classFiles;
    }

    private static List<String> findInJar(JarFile localJarFile, String packageName) {
        ArrayList classFiles = Lists.newArrayList();
        Enumeration<JarEntry> entries = localJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (jarEntry.isDirectory() || packageName != null && !entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
            String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
            classFiles.add(className);
        }
        return classFiles;
    }
}

