/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro.plugin;

import cn.dreampie.common.model.User;
import cn.dreampie.common.plugin.shiro.plugin.AuthzHandler;
import cn.dreampie.common.plugin.shiro.plugin.ShiroKit;
import cn.dreampie.common.util.SubjectUtils;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ShiroInterceptor.class);

    public void intercept(ActionInvocation ai) {
        List<AuthzHandler> ahs = ShiroKit.getAuthzHandler(ai.getController().getRequest(), ai.getActionKey());
        if (this.assertNoAuthorized(ai, ahs)) {
            return;
        }
        ai.invoke();
    }

    private boolean assertNoAuthorized(ActionInvocation ai, List<AuthzHandler> ahs) {
        if (ahs != null && ahs.size() > 0) {
            Subject subject;
            if (!SubjectUtils.me().wasLogin()) {
                WebUtils.saveRequest((ServletRequest)ai.getController().getRequest());
            }
            if (!(subject = SubjectUtils.me().getSubject()).isAuthenticated() && subject.isRemembered()) {
                Object principal = subject.getPrincipal();
                Session session = SubjectUtils.me().getSession();
                if (null != principal) {
                    if (session.getAttribute((Object)"currentUser") == null) {
                        session.setAttribute((Object)"currentUser", (Object)((User)((Object)principal)));
                    }
                } else {
                    SubjectUtils.me().getSubject().logout();
                }
            }
            try {
                for (AuthzHandler ah : ahs) {
                    ah.assertAuthorized();
                }
            }
            catch (UnauthenticatedException lae) {
                ai.getController().renderError(401);
                return true;
            }
            catch (AuthorizationException ae) {
                ai.getController().renderError(403);
                return true;
            }
            catch (Exception e) {
                ai.getController().renderError(401);
                return true;
            }
        }
        return false;
    }
}

