/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.shiro.plugin;

import cn.dreampie.common.plugin.shiro.plugin.AbstractAuthzHandler;
import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;

class PermissionAuthzHandler
extends AbstractAuthzHandler {
    private final Annotation annotation;

    public PermissionAuthzHandler(Annotation annotation) {
        this.annotation = annotation;
    }

    public PermissionAuthzHandler(String jdbcPermission) {
        this.annotation = null;
    }

    public void assertAuthorized() throws AuthorizationException {
        Subject subject = this.getSubject();
        if (!(this.annotation instanceof RequiresPermissions)) {
            return;
        }
        RequiresPermissions rpAnnotation = (RequiresPermissions)this.annotation;
        String[] perms = rpAnnotation.value();
        if (perms.length == 1) {
            subject.checkPermission(perms[0]);
            return;
        }
        if (Logical.AND.equals((Object)rpAnnotation.logical())) {
            this.getSubject().checkPermissions(perms);
            return;
        }
        if (Logical.OR.equals((Object)rpAnnotation.logical())) {
            boolean hasAtLeastOnePermission = false;
            for (String permission : perms) {
                if (!subject.isPermitted(permission)) continue;
                hasAtLeastOnePermission = true;
            }
            if (!hasAtLeastOnePermission) {
                subject.checkPermission(perms[0]);
            }
        }
    }
}

