/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.patchca;

import cn.dreampie.common.plugin.patchca.background.BackgroundFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;

class SimpleBackgroundFactory
implements BackgroundFactory {
    private Random random = new Random();
    private float alpha = 1.0f;

    SimpleBackgroundFactory() {
    }

    SimpleBackgroundFactory(float alpha) {
        this.alpha = alpha;
    }

    public void fillBackground(BufferedImage image) {
        int i;
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        graphics.setComposite(AlphaComposite.getInstance(10, this.alpha));
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, imgWidth, imgHeight);
        for (int i2 = 0; i2 < 50; ++i2) {
            graphics.setColor(new Color(102, 102, 102));
            int xInt = this.random.nextInt(imgWidth - 3);
            int yInt = this.random.nextInt(imgHeight - 2);
            int sAngleInt = this.random.nextInt(360);
            int eAngleInt = this.random.nextInt(360);
            int wInt = this.random.nextInt(6);
            int hInt = this.random.nextInt(6);
            graphics.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
        }
        graphics.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int cp = 4 + this.random.nextInt(3);
        int[] xPoints = new int[cp];
        int[] yPoints = new int[cp];
        imgWidth -= 10;
        for (int i3 = 0; i3 < cp; ++i3) {
            xPoints[i3] = 5 + i3 * imgWidth / (cp - 1);
            yPoints[i3] = (int)((double)imgHeight * (this.random.nextDouble() * 0.5 + 0.2));
        }
        int subsections = 6;
        int[] xPointsSpline = new int[(cp - 1) * subsections];
        int[] yPointsSpline = new int[(cp - 1) * subsections];
        for (i = 0; i < cp - 1; ++i) {
            double x0 = i > 0 ? (double)xPoints[i - 1] : (double)(2 * xPoints[i] - xPoints[i + 1]);
            double x1 = xPoints[i];
            double x2 = xPoints[i + 1];
            double x3 = i + 2 < cp ? (double)xPoints[i + 2] : (double)(2 * xPoints[i + 1] - xPoints[i]);
            double y0 = i > 0 ? (double)yPoints[i - 1] : (double)(2 * yPoints[i] - yPoints[i + 1]);
            double y1 = yPoints[i];
            double y2 = yPoints[i + 1];
            double y3 = i + 2 < cp ? (double)yPoints[i + 2] : (double)(2 * yPoints[i + 1] - yPoints[i]);
            for (int j = 0; j < subsections; ++j) {
                xPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(x0, x1, x2, x3, 1.0 / (double)subsections * (double)j);
                yPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(y0, y1, y2, y3, 1.0 / (double)subsections * (double)j);
            }
        }
        for (i = 0; i < xPointsSpline.length - 1; ++i) {
            graphics.setColor(new Color(102, 102, 102));
            graphics.setStroke(new BasicStroke(0.2f + 2.0f * this.random.nextFloat()));
            graphics.drawLine(xPointsSpline[i], yPointsSpline[i], xPointsSpline[i + 1], yPointsSpline[i + 1]);
        }
    }

    private double hermiteSpline(double x1, double a1, double x2, double a2, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double b = -a2 - 2.0 * a1 - 3.0 * x1 + 3.0 * x2;
        double a = a2 + a1 + 2.0 * x1 - 2.0 * x2;
        return a * t3 + b * t2 + a1 * t + x1;
    }

    private double catmullRomSpline(double x0, double x1, double x2, double x3, double t) {
        double a1 = (x2 - x0) / 2.0;
        double a2 = (x3 - x1) / 2.0;
        return this.hermiteSpline(x1, a1, x2, a2, t);
    }
}

