/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.lesscss.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.lesscss.LessException;
import org.lesscss.LessSource;
import org.lesscss.deps.org.apache.commons.io.FileUtils;
import org.lesscss.deps.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsLessCssCompiler {
    private static final List<String> resources = Arrays.asList("lessc.js", "less/visitor.js", "less/tree.js", "less/to-css-visitor.js", "less/source-map-output.js", "less/rhino.js", "less/parser.js", "less/lessc_helper.js", "less/join-selector-visitor.js", "less/index.js", "less/import-visitor.js", "less/functions.js", "less/extend-visitor.js", "less/env.js", "less/colors.js", "less/browser.js", "less/tree/variable.js", "less/tree/value.js", "less/tree/url.js", "less/tree/unicode-descriptor.js", "less/tree/selector.js", "less/tree/ruleset.js", "less/tree/rule.js", "less/tree/ratio.js", "less/tree/quoted.js", "less/tree/paren.js", "less/tree/operation.js", "less/tree/negative.js", "less/tree/mixin.js", "less/tree/media.js", "less/tree/keyword.js", "less/tree/javascript.js", "less/tree/import.js", "less/tree/extend.js", "less/tree/expression.js", "less/tree/element.js", "less/tree/directive.js", "less/tree/dimension.js", "less/tree/condition.js", "less/tree/comment.js", "less/tree/color.js", "less/tree/call.js", "less/tree/assignment.js", "less/tree/anonymous.js", "less/tree/alpha.js");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean compress;
    private final String encoding;
    private final File tempDir;
    private final String nodeExecutablePath;

    public NodeJsLessCssCompiler(boolean compress, String encoding, Logger logger) throws IOException {
        this("node", compress, encoding, logger);
    }

    public NodeJsLessCssCompiler(String nodeExecutablePath, boolean compress, String encoding, Logger logger) throws IOException {
        this.compress = compress;
        this.encoding = encoding;
        this.logger = logger;
        this.nodeExecutablePath = nodeExecutablePath;
        this.tempDir = NodeJsLessCssCompiler.createTempDir("lessc");
        new File(this.tempDir, "less/tree").mkdirs();
        for (String resource : resources) {
            InputStream in = NodeJsLessCssCompiler.class.getClassLoader().getResourceAsStream("org/lesscss/mojo/js/" + resource);
            FileOutputStream out = new FileOutputStream(new File(this.tempDir, resource));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
        }
    }

    public void close() {
        for (String resource : resources) {
            File tempFile = new File(this.tempDir, resource);
            if (tempFile.delete()) continue;
            this.logger.warn("Could not delete temp file: " + tempFile.getAbsolutePath());
        }
        File lessSubdir = new File(this.tempDir, "less");
        File treeSubdir = new File(lessSubdir, "tree");
        if (!treeSubdir.delete()) {
            this.logger.warn("Could not delete temp dir: " + treeSubdir.getAbsolutePath());
        }
        if (!lessSubdir.delete()) {
            this.logger.warn("Could not delete temp dir: " + lessSubdir.getAbsolutePath());
        }
        if (!this.tempDir.delete()) {
            this.logger.warn("Could not delete temp dir: " + this.tempDir.getAbsolutePath());
        }
    }

    public void compile(LessSource input, File output, boolean force) throws IOException, LessException, InterruptedException {
        if (force || !output.exists() || output.lastModified() < input.getLastModifiedIncludingImports()) {
            String data = this.compile(input.getNormalizedContent());
            FileUtils.writeStringToFile((File)output, (String)data, (String)this.encoding);
        }
    }

    private String compile(String input) throws LessException, IOException, InterruptedException {
        long start = System.currentTimeMillis();
        File inputFile = File.createTempFile("lessc-input-", ".less");
        FileOutputStream out = new FileOutputStream(inputFile);
        IOUtils.write((String)input, (OutputStream)out);
        out.close();
        File outputFile = File.createTempFile("lessc-output-", ".css");
        File lesscJsFile = new File(this.tempDir, "lessc.js");
        ProcessBuilder pb = new ProcessBuilder(this.nodeExecutablePath, lesscJsFile.getAbsolutePath(), inputFile.getAbsolutePath(), outputFile.getAbsolutePath(), String.valueOf(this.compress));
        pb.redirectErrorStream(true);
        Process process = pb.start();
        IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)System.out);
        int exitStatus = process.waitFor();
        FileInputStream in = new FileInputStream(outputFile);
        String result = IOUtils.toString((InputStream)in);
        in.close();
        if (!inputFile.delete()) {
            this.logger.warn("Could not delete temp file: " + inputFile.getAbsolutePath());
        }
        if (!outputFile.delete()) {
            this.logger.warn("Could not delete temp file: " + outputFile.getAbsolutePath());
        }
        if (exitStatus != 0) {
            throw new LessException(result, null);
        }
        this.logger.debug("Finished compilation of LESS source in " + (System.currentTimeMillis() - start) + " ms.");
        return result;
    }

    private static File createTempDir(String prefix) {
        int tempDirAttempts = 10000;
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = prefix + "-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }
}

