/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.lesscss.compiler;

import cn.dreampie.common.plugin.lesscss.compiler.AbstractLessCss;
import cn.dreampie.common.plugin.lesscss.compiler.LessCssException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.lesscss.LessSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessCssList
extends AbstractLessCss {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute() {
        String[] files;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sourceDirectory = " + this.sourceDirectory);
            this.logger.debug("includes = " + Arrays.toString(this.includes));
            this.logger.debug("excludes = " + Arrays.toString(this.excludes));
        }
        if ((files = this.getIncludedFiles()) == null || files.length < 1) {
            this.logger.info("No LESS sources found");
        } else {
            this.logger.info("The following LESS sources have been resolved:");
            for (String file : files) {
                File lessFile = new File(this.sourceDirectory, file);
                try {
                    LessSource lessSource = new LessSource(lessFile);
                    this.listLessSource(lessSource, file, 0, false);
                }
                catch (FileNotFoundException e) {
                    throw new LessCssException("Error while loading LESS source: " + lessFile.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    throw new LessCssException("Error while loading LESS source: " + lessFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private void listLessSource(LessSource lessSource, String path, int level, boolean last) {
        String prefix = "";
        if (level > 0) {
            for (int i = 1; i <= level; ++i) {
                prefix = i == level && last ? prefix + "`-- " : (i == level ? prefix + "|-- " : prefix + "|   ");
            }
        }
        this.logger.info(prefix + path);
        Iterator it = lessSource.getImports().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.listLessSource((LessSource)entry.getValue(), (String)entry.getKey(), level + 1, !it.hasNext());
        }
    }
}

