/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.plugin.coffeescript.compiler;

import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeException;
import cn.dreampie.common.plugin.coffeescript.compiler.CoffeeSource;
import cn.dreampie.common.plugin.coffeescript.compiler.Option;
import cn.dreampie.common.plugin.coffeescript.compiler.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeCompiler {
    private static Logger logger = LoggerFactory.getLogger(CoffeeCompiler.class);
    private URL coffeeJs = CoffeeCompiler.class.getClassLoader().getResource("/lib/coffee-script-1.7.1.min.js");
    private List<Option> optionArgs = Collections.emptyList();
    private String encoding = null;
    private Boolean compress = null;
    private Scriptable globalScope;
    private Options options;
    private static final int BUFFER_SIZE = 262144;
    private static final int BUFFER_OFFSET = 0;

    public CoffeeCompiler() {
        this(Collections.emptyList());
    }

    public URL getCoffeeJs() {
        return this.coffeeJs;
    }

    public synchronized void setCoffeeJs(URL coffeeJs) {
        this.coffeeJs = coffeeJs;
    }

    public boolean isCompress() {
        return this.compress != null && this.compress != false || this.optionArgs.contains((Object)Option.COMPRESS);
    }

    public synchronized void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public CoffeeCompiler(List<Option> options) {
        this.optionArgs = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        InputStream inputStream = null;
        if (this.coffeeJs == null) {
            logger.info("coffee-script file not found");
            inputStream = this.getClass().getResourceAsStream("/lib/coffee-script-1.7.1.min.js");
        } else {
            inputStream = this.coffeeJs.openConnection().getInputStream();
        }
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    Context context = Context.enter();
                    context.setOptimizationLevel(-1);
                    try {
                        this.globalScope = context.initStandardObjects();
                        context.evaluateReader(this.globalScope, (Reader)reader, "coffee-script.js", 0, null);
                    }
                    finally {
                        Context.exit();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String compile(String coffeeScriptSource) throws CoffeeException, IOException {
        return this.compile(coffeeScriptSource, "<inline>");
    }

    public String compile(String coffeeScriptSource, String name) throws CoffeeException, IOException {
        if (this.globalScope == null) {
            this.init();
        }
        this.options = new Options(this.optionArgs);
        Context context = Context.enter();
        try {
            Scriptable compileScope = context.newObject(this.globalScope);
            compileScope.setParentScope(this.globalScope);
            compileScope.put("coffeeScriptSource", compileScope, (Object)coffeeScriptSource);
            try {
                String string = (String)context.evaluateString(compileScope, String.format("CoffeeScript.compile(coffeeScriptSource, %s);", this.options.toJavaScript()), name, 0, null);
                return string;
            }
            catch (JavaScriptException e) {
                throw new CoffeeException(e);
            }
        }
        finally {
            Context.exit();
        }
    }

    public String compile(File input) throws IOException, CoffeeException {
        return this.compile(input, input.getName());
    }

    public void compile(File input, File output) throws IOException, CoffeeException {
        this.compile(input, output, true);
    }

    public void compile(File input, File output, boolean force) throws IOException, CoffeeException {
        if (force || !output.exists() || output.lastModified() < input.lastModified()) {
            String data = this.compile(input);
            FileUtils.writeStringToFile((File)output, (String)data, (String)this.encoding);
        }
    }

    public String compile(CoffeeSource input) throws CoffeeException, IOException {
        return this.compile(input.getNormalizedContent(), input.getName());
    }

    public void compile(CoffeeSource input, File output) throws IOException, CoffeeException {
        this.compile(input, output, true);
    }

    public void compile(CoffeeSource input, File output, boolean force) throws IOException, CoffeeException {
        if (force || !output.exists() && output.createNewFile() || output.lastModified() < input.getLastModifiedIncludingImports()) {
            String data = this.compile(input);
            FileUtils.writeStringToFile((File)output, (String)data, (String)this.encoding);
        }
    }

    public String compile(File input, String name) throws IOException, CoffeeException {
        String data = new CoffeeCompiler(this.optionArgs).compile(this.readSourceFrom(new FileInputStream(input)), name);
        return data;
    }

    public void compile(File input, File output, String name) throws IOException, CoffeeException {
        String data = new CoffeeCompiler(this.optionArgs).compile(this.readSourceFrom(new FileInputStream(input)), name);
        FileUtils.writeStringToFile((File)output, (String)data, (String)this.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSourceFrom(InputStream inputStream) {
        String string;
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        try {
            StringBuilder builder = new StringBuilder(262144);
            char[] buffer = new char[262144];
            int numCharsRead = streamReader.read(buffer, 0, 262144);
            while (numCharsRead >= 0) {
                builder.append(buffer, 0, numCharsRead);
                numCharsRead = streamReader.read(buffer, 0, 262144);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                streamReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        streamReader.close();
        return string;
    }

    private List<Option> readOptionsFrom(String ... args) {
        this.optionArgs = new LinkedList<Option>();
        if (args.length == 1 && args[0].equals("--bare")) {
            this.optionArgs.add(Option.BARE);
        }
        return this.optionArgs;
    }

    public List<Option> getOptionArgs() {
        return this.optionArgs;
    }

    public void setOptionArgs(String ... args) {
        this.optionArgs = this.readOptionsFrom(args);
    }
}

