/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.common.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.ext.kit.ClassSearcher;
import com.jfinal.ext.route.ControllerBind;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBindRoutes
extends Routes {
    private boolean autoScan = true;
    private List<Class<? extends Controller>> excludeClasses = Lists.newArrayList();
    private boolean includeAllJarsInLib;
    private List<String> includeJars = Lists.newArrayList();
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private String suffix = "Controller";

    public AutoBindRoutes autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoBindRoutes addExcludeClasses(Class<? extends Controller> ... clazzes) {
        if (clazzes != null) {
            for (Class<? extends Controller> clazz : clazzes) {
                this.excludeClasses.add(clazz);
            }
        }
        return this;
    }

    public AutoBindRoutes addExcludeClasses(List<Class<? extends Controller>> clazzes) {
        this.excludeClasses.addAll(clazzes);
        return this;
    }

    public AutoBindRoutes addJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    public void config() {
        List controllerClasses = ClassSearcher.of(Controller.class).includeAllJarsInLib(this.includeAllJarsInLib).injars(this.includeJars).search();
        ControllerBind controllerBind = null;
        for (Class controller : controllerClasses) {
            if (this.excludeClasses.contains(controller)) continue;
            controllerBind = controller.getAnnotation(ControllerBind.class);
            if (controllerBind == null) {
                if (!this.autoScan) continue;
                this.add(this.controllerKey(controller), controller);
                this.logger.debug("routes.add(" + this.controllerKey(controller) + ", " + controller.getName() + ")");
                continue;
            }
            if (StrKit.isBlank((String)controllerBind.viewPath())) {
                this.add(controllerBind.controllerKey(), controller);
                this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + controller.getName() + ")");
                continue;
            }
            this.add(controllerBind.controllerKey(), controller, controllerBind.viewPath());
            this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + controller + "," + controllerBind.viewPath() + ")");
        }
    }

    private String controllerKey(Class<Controller> clazz) {
        Preconditions.checkArgument((boolean)clazz.getSimpleName().endsWith(this.suffix), (Object)(" does not has a @ControllerBind annotation and it's name is not end with " + this.suffix));
        String simpleName = clazz.getSimpleName();
        String controllerKey = "/";
        if (!simpleName.equalsIgnoreCase(this.suffix)) {
            controllerKey = controllerKey + StrKit.firstCharToLowerCase((String)simpleName.replace(this.suffix, ""));
        }
        return controllerKey;
    }

    public AutoBindRoutes includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public AutoBindRoutes suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }
}

