/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.payment.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.pay.base.BaseResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties
public class RefundQuery
extends BaseResponse {
    @JsonProperty(value="transaction_id")
    private String transactionId;
    @JsonProperty(value="out_trade_no")
    private String tradeNumber;
    @JsonProperty(value="total_fee")
    private int totalFee;
    @JsonProperty(value="settlement_total_fee")
    private int settlementTotalFee;
    @JsonProperty(value="fee_type")
    private String feeType;
    @JsonProperty(value="cash_fee")
    private int cashFee;
    @JsonProperty(value="refund_count")
    private int refundCount;
    @JsonProperty(value="refund_account")
    private String refundAccount;
    protected Map<String, Object> others = new HashMap<String, Object>();

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTradeNumber() {
        return this.tradeNumber;
    }

    public void setTradeNumber(String tradeNumber) {
        this.tradeNumber = tradeNumber;
    }

    public int getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    public int getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public void setSettlementTotalFee(int settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public int getCashFee() {
        return this.cashFee;
    }

    public void setCashFee(int cashFee) {
        this.cashFee = cashFee;
    }

    public int getRefundCount() {
        return this.refundCount;
    }

    public void setRefundCount(int refundCount) {
        this.refundCount = refundCount;
    }

    public String getRefundAccount() {
        return this.refundAccount;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    @JsonIgnore
    public List<Refund> getRefunds() {
        ArrayList<Refund> refunds = new ArrayList<Refund>();
        if (this.others.size() > 0) {
            for (int i = 0; i < this.refundCount; ++i) {
                Refund refund = new Refund();
                if (this.others.containsKey("out_refund_no_" + i)) {
                    refund.setOutRefundNo((String)this.others.get("out_refund_no_" + i));
                }
                if (this.others.containsKey("refund_id_" + i)) {
                    refund.setRefundId((String)this.others.get("refund_id_" + i));
                }
                if (this.others.containsKey("refund_channel_" + i)) {
                    refund.setRefundChannel((String)this.others.get("refund_channel_" + i));
                }
                if (this.others.containsKey("refund_fee_" + i)) {
                    refund.setRefundFee(Integer.valueOf(this.others.get("refund_fee_" + i).toString()));
                }
                if (this.others.containsKey("settlement_refund_fee_" + i)) {
                    refund.setSettlementRefundFee(Integer.valueOf(this.others.get("settlement_refund_fee_" + i).toString()));
                }
                if (this.others.containsKey("coupon_type_" + i)) {
                    refund.setCouponType((String)this.others.get("coupon_type_" + i));
                }
                if (this.others.containsKey("coupon_refund_fee_" + i)) {
                    refund.setCouponRefundFee(Integer.valueOf(this.others.get("coupon_refund_fee_" + i).toString()));
                }
                if (this.others.containsKey("coupon_refund_count_" + i)) {
                    int count = Integer.valueOf(this.others.get("coupon_refund_count_" + i).toString());
                    refund.setCouponRefundCount(count);
                    ArrayList<CouponRefund> couponRefunds = new ArrayList<CouponRefund>();
                    for (int j = 0; j < count; ++j) {
                        CouponRefund couponRefund = new CouponRefund();
                        if (this.others.containsKey("coupon_refund_id_" + i + "_" + j)) {
                            couponRefund.setCouponRefundId((String)this.others.get("coupon_refund_id_" + i + "_" + j));
                        }
                        if (this.others.containsKey("coupon_refund_fee_" + i + "_" + j)) {
                            couponRefund.setCouponRefundFee(Integer.valueOf(this.others.get("coupon_refund_fee_" + i + "_" + j).toString()));
                        }
                        couponRefunds.add(couponRefund);
                    }
                    refund.setCouponRefunds(couponRefunds);
                }
                if (this.others.containsKey("refund_status_" + i)) {
                    refund.setRefundStatus((String)this.others.get("refund_status_" + i));
                }
                if (this.others.containsKey("refund_recv_accout_" + i)) {
                    refund.setRefundReceiveAccount((String)this.others.get("refund_recv_accout_" + i));
                }
                refunds.add(refund);
            }
        }
        return refunds;
    }

    public class CouponRefund {
        private String couponRefundId;
        private int couponRefundFee;

        public String getCouponRefundId() {
            return this.couponRefundId;
        }

        public void setCouponRefundId(String couponRefundId) {
            this.couponRefundId = couponRefundId;
        }

        public int getCouponRefundFee() {
            return this.couponRefundFee;
        }

        public void setCouponRefundFee(int couponRefundFee) {
            this.couponRefundFee = couponRefundFee;
        }
    }

    public class Refund {
        private String outRefundNo;
        private String refundId;
        private String refundChannel;
        private int refundFee;
        private int settlementRefundFee;
        private String couponType;
        private int couponRefundFee;
        private int couponRefundCount;
        private String refundStatus;
        private String refundReceiveAccount;
        private List<CouponRefund> couponRefunds;

        public String getOutRefundNo() {
            return this.outRefundNo;
        }

        public void setOutRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }

        public String getRefundChannel() {
            return this.refundChannel;
        }

        public void setRefundChannel(String refundChannel) {
            this.refundChannel = refundChannel;
        }

        public int getRefundFee() {
            return this.refundFee;
        }

        public void setRefundFee(int refundFee) {
            this.refundFee = refundFee;
        }

        public int getSettlementRefundFee() {
            return this.settlementRefundFee;
        }

        public void setSettlementRefundFee(int settlementRefundFee) {
            this.settlementRefundFee = settlementRefundFee;
        }

        public String getCouponType() {
            return this.couponType;
        }

        public void setCouponType(String couponType) {
            this.couponType = couponType;
        }

        public int getCouponRefundFee() {
            return this.couponRefundFee;
        }

        public void setCouponRefundFee(int couponRefundFee) {
            this.couponRefundFee = couponRefundFee;
        }

        public int getCouponRefundCount() {
            return this.couponRefundCount;
        }

        public void setCouponRefundCount(int couponRefundCount) {
            this.couponRefundCount = couponRefundCount;
        }

        public String getRefundStatus() {
            return this.refundStatus;
        }

        public void setRefundStatus(String refundStatus) {
            this.refundStatus = refundStatus;
        }

        public String getRefundReceiveAccount() {
            return this.refundReceiveAccount;
        }

        public void setRefundReceiveAccount(String refundReceiveAccount) {
            this.refundReceiveAccount = refundReceiveAccount;
        }

        public List<CouponRefund> getCouponRefunds() {
            return this.couponRefunds;
        }

        public void setCouponRefunds(List<CouponRefund> couponRefunds) {
            this.couponRefunds = couponRefunds;
        }
    }
}

