/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.payment;

import com.riversoft.weixin.common.util.MD5;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.payment.bean.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signatures {
    private static Logger logger = LoggerFactory.getLogger(Signatures.class);
    private PaySetting paySetting;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static Signatures defaultSignatures() {
        return Signatures.with(PaySetting.defaultSetting());
    }

    public static Signatures with(PaySetting paySetting) {
        Signatures signatures = new Signatures();
        signatures.setPaySetting(paySetting);
        return signatures;
    }

    public Signature createAppSignature(String prepayId) {
        String pack = "Sign=WXPay";
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String appId = this.paySetting.getAppId();
        String mchId = this.paySetting.getMchId();
        String key = this.paySetting.getKey();
        String sortString = String.format("appId=%s&nonceStr=%s&package=%s&partnerid=%s&&prepayid=%s&timeStamp=%s", appId, nonce, pack, mchId, prepayId, timestamp);
        return this.createSignature(pack, timestamp, nonce, appId, key, sortString);
    }

    public Signature createJsSignature(String prepayId) {
        String pack = "prepay_id=" + prepayId;
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String appId = this.paySetting.getAppId();
        String key = this.paySetting.getKey();
        String sortString = String.format("appId=%s&nonceStr=%s&package=%s&signType=MD5&timeStamp=%s", appId, nonce, pack, timestamp);
        return this.createSignature(pack, timestamp, nonce, appId, key, sortString);
    }

    private Signature createSignature(String pack, long timestamp, String nonce, String appId, String key, String sortString) {
        String signature = MD5.md5Hex((String)(sortString + "&key=" + key)).toUpperCase();
        Signature sign = new Signature();
        sign.setAppId(appId);
        sign.setNonce(nonce);
        sign.setTimestamp(timestamp);
        sign.setSignature(signature);
        sign.setPack(pack);
        return sign;
    }
}

