/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.payment;

import com.riversoft.weixin.common.WxSslClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import com.riversoft.weixin.pay.PayWxClientFactory;
import com.riversoft.weixin.pay.base.BaseResponse;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.base.WxEndpoint;
import com.riversoft.weixin.pay.payment.bean.OrderQueryRequest;
import com.riversoft.weixin.pay.payment.bean.OrderQueryResponse;
import com.riversoft.weixin.pay.payment.bean.PaymentNotification;
import com.riversoft.weixin.pay.payment.bean.RefundQuery;
import com.riversoft.weixin.pay.payment.bean.RefundRequest;
import com.riversoft.weixin.pay.payment.bean.RefundResponse;
import com.riversoft.weixin.pay.payment.bean.UnifiedOrderRequest;
import com.riversoft.weixin.pay.payment.bean.UnifiedOrderResponse;
import com.riversoft.weixin.pay.payment.wrapper.BaseSettings;
import com.riversoft.weixin.pay.payment.wrapper.BillRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.OrderCloseRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.OrderCloseResponseWrapper;
import com.riversoft.weixin.pay.payment.wrapper.OrderQueryRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.OrderQueryResponseWrapper;
import com.riversoft.weixin.pay.payment.wrapper.RefundQueryRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.RefundQueryWrapper;
import com.riversoft.weixin.pay.payment.wrapper.RefundRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.RefundResponseWrapper;
import com.riversoft.weixin.pay.payment.wrapper.UnifiedOrderRequestWrapper;
import com.riversoft.weixin.pay.payment.wrapper.UnifiedOrderResponseWrapper;
import com.riversoft.weixin.pay.util.SignatureUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Payments {
    private static Logger logger = LoggerFactory.getLogger(Payments.class);
    private PaySetting paySetting;
    private WxSslClient wxSslClient;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static Payments defaultPayments() {
        return Payments.with(PaySetting.defaultSetting());
    }

    public static Payments with(PaySetting paySetting) {
        Payments payments = new Payments();
        payments.setPaySetting(paySetting);
        payments.setWxSslClient(PayWxClientFactory.getInstance().with(paySetting));
        return payments;
    }

    public void setWxSslClient(WxSslClient wxSslClient) {
        this.wxSslClient = wxSslClient;
    }

    public UnifiedOrderResponse unifiedOrder(UnifiedOrderRequest unifiedOrderRequest) {
        UnifiedOrderRequestWrapper wrapper = new UnifiedOrderRequestWrapper();
        wrapper.setRequest(unifiedOrderRequest);
        this.setBaseSettings(wrapper);
        SortedMap unifiedOrderRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, unifiedOrderRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.unified");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 unified order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 unified order response: {}", (Object)response);
            UnifiedOrderResponseWrapper responseWrapper = (UnifiedOrderResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, UnifiedOrderResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "pre order failed:" + e.getMessage());
        }
    }

    public OrderQueryResponse query(OrderQueryRequest orderQueryRequest) {
        OrderQueryRequestWrapper wrapper = new OrderQueryRequestWrapper();
        wrapper.setRequest(orderQueryRequest);
        this.setBaseSettings(wrapper);
        SortedMap queryRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, queryRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.query");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 query order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 query order response: {}", (Object)response);
            OrderQueryResponseWrapper responseWrapper = (OrderQueryResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, OrderQueryResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "query order failed:" + e.getMessage());
        }
    }

    public BaseResponse close(String tradeNumber) {
        OrderCloseRequestWrapper wrapper = new OrderCloseRequestWrapper();
        wrapper.setTradeNumber(tradeNumber);
        this.setBaseSettings(wrapper);
        SortedMap closeOrderRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, closeOrderRequestMap);
        String url = WxEndpoint.get("url.pay.payment.order.close");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 close order request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 close order response: {}", (Object)response);
            OrderCloseResponseWrapper responseWrapper = (OrderCloseResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, OrderCloseResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "close order failed:" + e.getMessage());
        }
    }

    public boolean checkSignature(PaymentNotification notification) {
        SortedMap notificationMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)notification, SortedMap.class);
        notificationMap.remove("sign");
        return notification.getSign().equals(SignatureUtil.sign(notificationMap, this.paySetting.getKey()));
    }

    public RefundResponse refund(RefundRequest refundRequest) {
        RefundRequestWrapper wrapper = new RefundRequestWrapper();
        wrapper.setRequest(refundRequest);
        this.setBaseSettings(wrapper);
        SortedMap refundRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        this.sign(wrapper, refundRequestMap);
        String url = WxEndpoint.get("url.pay.payment.refund.refund");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)wrapper);
            logger.info("\u652f\u4ed8 refund request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 refund response: {}", (Object)response);
            RefundResponseWrapper responseWrapper = (RefundResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RefundResponseWrapper.class);
            return responseWrapper.getResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "refund failed:" + e.getMessage());
        }
    }

    public RefundQuery refundQueryByTransactionId(String transactionId) {
        RefundQueryRequestWrapper refundQueryRequestWrapper = new RefundQueryRequestWrapper();
        refundQueryRequestWrapper.setTransactionId(transactionId);
        return this.refundQuery(refundQueryRequestWrapper);
    }

    public RefundQuery refundQueryByTradeNumber(String tradeNumber) {
        RefundQueryRequestWrapper refundQueryRequestWrapper = new RefundQueryRequestWrapper();
        refundQueryRequestWrapper.setTradeNumber(tradeNumber);
        return this.refundQuery(refundQueryRequestWrapper);
    }

    public RefundQuery refundQueryByRefundNumber(String refundNumber) {
        RefundQueryRequestWrapper refundQueryRequestWrapper = new RefundQueryRequestWrapper();
        refundQueryRequestWrapper.setRefundNumber(refundNumber);
        return this.refundQuery(refundQueryRequestWrapper);
    }

    public RefundQuery refundQueryByRefundId(String refundId) {
        RefundQueryRequestWrapper refundQueryRequestWrapper = new RefundQueryRequestWrapper();
        refundQueryRequestWrapper.setRefundId(refundId);
        return this.refundQuery(refundQueryRequestWrapper);
    }

    public RefundQuery refundQuery(RefundQueryRequestWrapper refundQueryRequestWrapper) {
        this.setBaseSettings(refundQueryRequestWrapper);
        SortedMap refundQueryRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)refundQueryRequestWrapper, SortedMap.class);
        this.sign(refundQueryRequestWrapper, refundQueryRequestMap);
        String url = WxEndpoint.get("url.pay.payment.refund.query");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)refundQueryRequestWrapper);
            logger.info("\u652f\u4ed8 refund query request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 refund query response: {}", (Object)response);
            RefundQueryWrapper refundQueryWrapper = (RefundQueryWrapper)XmlObjectMapper.defaultMapper().fromXml(response, RefundQueryWrapper.class);
            refundQueryWrapper.ready();
            return refundQueryWrapper.getRefundQuery();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "refund query failed:" + e.getMessage());
        }
    }

    public String downloadAllBill(Date date) {
        return this.downloadBill(date, "ALL");
    }

    public String downloadRefundBill(Date date) {
        return this.downloadBill(date, "REFUND");
    }

    public String downloadSuccessBill(Date date) {
        return this.downloadBill(date, "SUCCESS");
    }

    private String downloadBill(Date date, String type) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        BillRequestWrapper billRequestWrapper = new BillRequestWrapper();
        billRequestWrapper.setDate(dateFormat.format(date));
        billRequestWrapper.setType(type);
        this.setBaseSettings(billRequestWrapper);
        SortedMap billRequestMap = (SortedMap)JsonMapper.nonEmptyMapper().getMapper().convertValue((Object)billRequestWrapper, SortedMap.class);
        this.sign(billRequestWrapper, billRequestMap);
        String url = WxEndpoint.get("url.pay.payment.bill.download");
        try {
            String xml = XmlObjectMapper.nonEmptyMapper().toXml((Object)billRequestWrapper);
            logger.info("\u652f\u4ed8 bill download request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("\u652f\u4ed8 bill download response: {}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "bill download failed:" + e.getMessage());
        }
    }

    private void setBaseSettings(BaseSettings wrapper) {
        wrapper.setAppId(this.paySetting.getAppId());
        wrapper.setMchId(this.paySetting.getMchId());
    }

    private void sign(BaseSettings wrapper, SortedMap<String, Object> generals) {
        String nonce = RandomStringGenerator.getRandomStringByLength((int)32);
        generals.put("nonce_str", nonce);
        generals.put("mch_id", this.paySetting.getMchId());
        wrapper.setNonce(nonce);
        wrapper.setSign(SignatureUtil.sign(generals, this.paySetting.getKey()));
    }
}

