/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.user.bean.Tag;
import com.riversoft.weixin.mp.user.bean.UserPagination;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tags {
    private static Logger logger = LoggerFactory.getLogger(Tags.class);
    private WxClient wxClient;

    public static Tags defaultTags() {
        return Tags.with(AppSetting.defaultSettings());
    }

    public static Tags with(AppSetting appSetting) {
        Tags tags = new Tags();
        tags.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return tags;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Tag create(String name) {
        String url = WxEndpoint.get("url.tag.create");
        TagWrapper tag = new TagWrapper(name);
        String json = JsonMapper.nonEmptyMapper().toJson((Object)tag);
        logger.debug("create tag: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        TagWrapper wrapper = (TagWrapper)JsonMapper.defaultMapper().fromJson(response, TagWrapper.class);
        return wrapper.getTag();
    }

    public void update(Tag tag) {
        String url = WxEndpoint.get("url.tag.update");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)new TagWrapper(tag));
        logger.debug("update tag: {}", (Object)tag);
        this.wxClient.post(url, json);
    }

    public void delete(int id) {
        String url = WxEndpoint.get("url.tag.delete");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)new TagWrapper(id));
        logger.debug("delete tag: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public List<Tag> list() {
        String url = WxEndpoint.get("url.tag.list");
        String response = this.wxClient.get(url);
        TagList tagList = (TagList)JsonMapper.defaultMapper().fromJson(response, TagList.class);
        return tagList.getTags();
    }

    public UserPagination listUsers(int tagId) {
        return this.listUsers(tagId, null);
    }

    public UserPagination listUsers(int tagId, String nextOpenId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tagid", tagId);
        String url = WxEndpoint.get("url.tag.user.list");
        if (nextOpenId != null && !"".equals(nextOpenId)) {
            map.put("next_openid", nextOpenId);
        }
        String response = this.wxClient.post(url, JsonMapper.defaultMapper().toJson(map));
        logger.debug("list tag users: {}", (Object)response);
        return (UserPagination)JsonMapper.defaultMapper().fromJson(response, UserPagination.class);
    }

    public void tagUsers(int tagId, List<String> openIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tagid", tagId);
        map.put("openid_list", openIds);
        String url = WxEndpoint.get("url.tag.user.tag");
        logger.debug("add tag for users: {}", (Object)JsonMapper.defaultMapper().toJson(map));
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(map));
    }

    public void unTagUsers(int tagId, List<String> openIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tagid", tagId);
        map.put("openid_list", openIds);
        String url = WxEndpoint.get("url.tag.user.untag");
        logger.debug("remove tag for users: {}", (Object)JsonMapper.defaultMapper().toJson(map));
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(map));
    }

    public List<Integer> getUserTags(String openId) {
        String url = WxEndpoint.get("url.tag.user.gettag");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openid", openId);
        String response = this.wxClient.post(url, JsonMapper.nonEmptyMapper().toJson(map));
        TagIdsWrapper tagIdsWrapper = (TagIdsWrapper)JsonMapper.defaultMapper().fromJson(response, TagIdsWrapper.class);
        return tagIdsWrapper.getList();
    }

    public static class TagIdsWrapper {
        @JsonProperty(value="tagid_list")
        private List<Integer> list;

        public List<Integer> getList() {
            return this.list;
        }

        public void setList(List<Integer> list) {
            this.list = list;
        }
    }

    public static class TagWrapper {
        private Tag tag;

        public TagWrapper() {
        }

        public TagWrapper(int id) {
            Tag tag = new Tag();
            tag.setId(id);
            this.tag = tag;
        }

        public TagWrapper(String name) {
            Tag tag = new Tag();
            tag.setName(name);
            this.tag = tag;
        }

        public TagWrapper(Tag tag) {
            this.tag = tag;
        }

        public Tag getTag() {
            return this.tag;
        }

        public void setTag(Tag tag) {
            this.tag = tag;
        }
    }

    public static class TagList {
        @JsonProperty(value="tags")
        private List<Tag> tags;

        public List<Tag> getTags() {
            return this.tags;
        }

        public void setTags(List<Tag> tags) {
            this.tags = tags;
        }
    }
}

