/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.user;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.user.bean.UserPagination;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackLists {
    private static Logger logger = LoggerFactory.getLogger(BlackLists.class);
    private WxClient wxClient;

    public static BlackLists defaultBlackLists() {
        return BlackLists.with(AppSetting.defaultSettings());
    }

    public static BlackLists with(AppSetting appSetting) {
        BlackLists blackLists = new BlackLists();
        blackLists.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return blackLists;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void black(List<String> openids) {
        String url = WxEndpoint.get("url.blacklist.black");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("opened_list", openids);
        logger.debug("black users: {}", openids);
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(body));
    }

    public void unblack(List<String> openids) {
        String url = WxEndpoint.get("url.blacklist.unblack");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("opened_list", openids);
        logger.debug("unblack users: {}", openids);
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(body));
    }

    public UserPagination list() {
        return this.list("");
    }

    public UserPagination list(String nextOpenId) {
        String url = WxEndpoint.get("url.blacklist.list");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("begin_openid", nextOpenId);
        logger.debug("list all black list: {}", (Object)nextOpenId);
        String response = this.wxClient.post(url, JsonMapper.defaultMapper().toJson(body));
        return (UserPagination)JsonMapper.defaultMapper().fromJson(response, UserPagination.class);
    }
}

