/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.oauth2;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.oauth2.AccessToken;
import com.riversoft.weixin.common.oauth2.OpenUser;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.URLEncoder;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpOAuth2s {
    private static Logger logger = LoggerFactory.getLogger(MpOAuth2s.class);
    private WxClient wxClient;

    public static MpOAuth2s defaultOAuth2s() {
        return MpOAuth2s.with(AppSetting.defaultSettings());
    }

    public static MpOAuth2s with(AppSetting appSetting) {
        MpOAuth2s mpOAuth2S = new MpOAuth2s();
        mpOAuth2S.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return mpOAuth2S;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String authenticationUrl(String redirect, String scope) {
        return this.authenticationUrl(redirect, scope, null);
    }

    public String authenticationUrl(String redirect, String scope, String state) {
        if (state == null || "".equals(state)) {
            String url = WxEndpoint.get("url.oauth.authentication");
            return String.format(url, this.wxClient.getClientId(), URLEncoder.encode((String)redirect), scope);
        }
        String url = WxEndpoint.get("url.oauth.authentication.state");
        return String.format(url, this.wxClient.getClientId(), URLEncoder.encode((String)redirect), scope, state);
    }

    public AccessToken getAccessToken(String code) {
        String url = WxEndpoint.get("url.oauth.accesstoken.get");
        String formatUrl = String.format(url, this.wxClient.getClientId(), this.wxClient.getClientSecret(), code);
        logger.debug("get access token: {}", (Object)formatUrl);
        String response = this.wxClient.get(formatUrl, false);
        return (AccessToken)JsonMapper.defaultMapper().fromJson(response, AccessToken.class);
    }

    public AccessToken refreshToken(String refreshToken) {
        String url = WxEndpoint.get("url.oauth.accesstoken.refresh");
        String formatUrl = String.format(url, this.wxClient.getClientId(), refreshToken);
        logger.debug("refresh access token: {}", (Object)formatUrl);
        String response = this.wxClient.get(formatUrl, false);
        return (AccessToken)JsonMapper.defaultMapper().fromJson(response, AccessToken.class);
    }

    public OpenUser userInfo(String accessToken, String openId) {
        return this.userInfo(accessToken, openId, "zh_CN");
    }

    public OpenUser userInfo(String accessToken, String openId, String lang) {
        String url = WxEndpoint.get("url.oauth.userinfo.get");
        String formatUrl = String.format(url, accessToken, openId, lang);
        logger.debug("get user info {}", (Object)formatUrl);
        String response = this.wxClient.get(formatUrl, false);
        return (OpenUser)JsonMapper.defaultMapper().fromJson(response, OpenUser.class);
    }
}

