/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpMessages {
    private static Logger logger = LoggerFactory.getLogger(MpMessages.class);
    private WxClient wxClient;

    public static MpMessages defaultMpMessages() {
        return MpMessages.with(AppSetting.defaultSettings());
    }

    public static MpMessages with(AppSetting appSetting) {
        MpMessages messages = new MpMessages();
        messages.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return messages;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public long mpNews(String mpNews) {
        return this.send(new Filter(true, null), null, "mpnews", mpNews);
    }

    public long mpNews(int group, String mpNews) {
        return this.send(new Filter(false, String.valueOf(group)), null, "mpnews", mpNews);
    }

    public long mpNews(List<String> openIds, String mpNews) {
        return this.send(null, openIds, "mpnews", mpNews);
    }

    public long text(String text) {
        return this.send(new Filter(true, null), null, "text", text);
    }

    public long text(int group, String text) {
        return this.send(new Filter(false, String.valueOf(group)), null, "text", text);
    }

    public long text(List<String> openIds, String text) {
        return this.send(null, openIds, "text", text);
    }

    public long textPreview(String wxName, String openId, String text) {
        return this.preview(wxName, openId, "text", text);
    }

    public long voice(String voice) {
        return this.send(new Filter(true, null), null, "voice", voice);
    }

    public long voice(List<String> openIds, String voice) {
        return this.send(null, openIds, "voice", voice);
    }

    public long voice(int group, String voice) {
        return this.send(new Filter(false, String.valueOf(group)), null, "voice", voice);
    }

    public long voicePreview(String wxName, String openId, String voice) {
        return this.preview(wxName, openId, "voice", voice);
    }

    public long image(String image) {
        return this.send(new Filter(true, null), null, "image", image);
    }

    public long image(int group, String image) {
        return this.send(new Filter(false, String.valueOf(group)), null, "image", image);
    }

    public long image(List<String> openIds, String image) {
        return this.send(null, openIds, "image", image);
    }

    public long imagePreview(String wxName, String openId, String image) {
        return this.preview(wxName, openId, "image", image);
    }

    public long video(String mediaId, String title, String desc) {
        return this.video(new Filter(true, null), null, mediaId, title, desc);
    }

    public long video(int group, String mediaId, String title, String desc) {
        return this.video(new Filter(false, String.valueOf(group)), null, mediaId, title, desc);
    }

    public long video(List<String> openIds, String mediaId, String title, String desc) {
        return this.video(null, openIds, mediaId, title, desc);
    }

    public long videoPreview(String wxName, String openId, String mediaId, String title, String desc) {
        HashMap<String, String> uploadRequest = new HashMap<String, String>();
        uploadRequest.put("media_id", mediaId);
        uploadRequest.put("title", title);
        uploadRequest.put("description", desc);
        String uploadUrl = WxEndpoint.get("url.mass.message.video.upload");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)uploadUrl);
        String response = this.wxClient.post(uploadUrl, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return this.preview(wxName, openId, "mpvideo", (String)result.get("media_id"));
        }
        throw new WxRuntimeException(999, "send mp video preview failed.");
    }

    public long card(String wxcard) {
        return this.send(new Filter(true, null), null, "wxcard", wxcard);
    }

    public long card(int group, String wxcard) {
        return this.send(new Filter(false, String.valueOf(group)), null, "wxcard", wxcard);
    }

    public long card(List<String> openIds, String wxcard) {
        return this.send(null, openIds, "wxcard", wxcard);
    }

    public long cardPreview(String wxName, String openId, String wxcard) {
        return this.preview(wxName, openId, "wxcard", wxcard);
    }

    public void delete(long msgId) {
        String url = WxEndpoint.get("url.mass.message.delete");
        String request = "{\"msg_id\":%s}";
        logger.debug("delete message: {}", (Object)msgId);
        this.wxClient.post(url, String.format(request, msgId));
    }

    public boolean success(long msgId) {
        String url = WxEndpoint.get("url.mass.message.status");
        String request = "{\"msg_id\":%s}";
        logger.debug("check message sending status: {}", (Object)msgId);
        String response = this.wxClient.post(url, String.format(request, msgId));
        HashMap map = JsonMapper.defaultMapper().json2Map(response);
        return map.containsKey("msg_status") && "SEND_SUCCESS".equalsIgnoreCase(map.get("msg_status").toString());
    }

    private long send(Filter filter, List<String> openIds, String msgType, String message) {
        String url = WxEndpoint.get("url.mass.message.send");
        HashMap<String, Object> request = new HashMap<String, Object>();
        if (filter != null) {
            request.put("filter", filter);
        }
        if (openIds != null && !openIds.isEmpty()) {
            request.put("touser", openIds);
        }
        request.put("msgtype", msgType);
        if ("wxcard".equalsIgnoreCase(msgType)) {
            request.put(msgType, new Card(message));
        } else if ("text".equalsIgnoreCase(msgType)) {
            request.put(msgType, new Text(message));
        } else {
            request.put(msgType, new Media(message));
        }
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("send message: {}", (Object)json);
        String result = this.wxClient.post(url, json);
        Response response = (Response)JsonMapper.defaultMapper().fromJson(result, Response.class);
        return response.getMsgId();
    }

    private long preview(String wxName, String openId, String msgType, String message) {
        String url = WxEndpoint.get("url.mass.message.preview");
        HashMap<String, Object> request = new HashMap<String, Object>();
        if (wxName != null && !"".equals(wxName)) {
            request.put("towxname", wxName);
        }
        if (openId != null && !"".equals(openId)) {
            request.put("touser", openId);
        }
        request.put("msgtype", msgType);
        if ("wxcard".equalsIgnoreCase(msgType)) {
            request.put(msgType, new Card(message));
        } else if ("text".equalsIgnoreCase(msgType)) {
            request.put(msgType, new Text(message));
        } else {
            request.put(msgType, new Media(message));
        }
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("preview message: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        Response r = (Response)JsonMapper.defaultMapper().fromJson(response, Response.class);
        return r.getMsgId();
    }

    private long video(Filter filter, List<String> openIds, String mediaId, String title, String desc) {
        HashMap<String, String> uploadRequest = new HashMap<String, String>();
        uploadRequest.put("media_id", mediaId);
        uploadRequest.put("title", title);
        uploadRequest.put("description", desc);
        String uploadUrl = WxEndpoint.get("url.mass.message.video.upload");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)uploadUrl);
        String response = this.wxClient.post(uploadUrl, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return this.send(filter, openIds, "mpvideo", (String)result.get("media_id"));
        }
        throw new WxRuntimeException(999, "send mp video failed.");
    }

    public static class Response {
        @JsonProperty(value="msg_id")
        private long msgId;
        @JsonProperty(value="msg_data_id")
        private long msgDataId;

        public long getMsgId() {
            return this.msgId;
        }

        public void setMsgId(long msgId) {
            this.msgId = msgId;
        }

        public long getMsgDataId() {
            return this.msgDataId;
        }

        public void setMsgDataId(long msgDataId) {
            this.msgDataId = msgDataId;
        }
    }

    public static class Text {
        private String content;

        public Text(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }

    public static class Card {
        @JsonProperty(value="card_id")
        private String cardId;

        public Card(String cardId) {
            this.cardId = cardId;
        }

        public String getCardId() {
            return this.cardId;
        }

        public void setCardId(String cardId) {
            this.cardId = cardId;
        }
    }

    public static class Media {
        @JsonProperty(value="media_id")
        private String mediaId;

        public Media(String mediaId) {
            this.mediaId = mediaId;
        }

        public String getMediaId() {
            return this.mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }
    }

    public static class Filter {
        @JsonProperty(value="is_to_all")
        private boolean toALl;
        @JsonProperty(value="group_id")
        private String group;

        public Filter(boolean toALl, String group) {
            this.toALl = toALl;
            this.group = group;
        }

        public boolean isToALl() {
            return this.toALl;
        }

        public void setToALl(boolean toALl) {
            this.toALl = toALl;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }
    }
}

