/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.menu;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.menu.Menu;
import com.riversoft.weixin.common.menu.RuleMenu;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.menu.bean.MenuConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Menus {
    private static Logger logger = LoggerFactory.getLogger(Menus.class);
    private WxClient wxClient;

    public static Menus defaultMenus() {
        return Menus.with(AppSetting.defaultSettings());
    }

    public static Menus with(AppSetting appSetting) {
        Menus menus = new Menus();
        menus.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return menus;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void create(Menu menu) {
        String url = WxEndpoint.get("url.menu.create");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)menu);
        logger.debug("create menu: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public String createRuleMenu(RuleMenu menu) {
        String url = WxEndpoint.get("url.menu.create.condition");
        if (menu.getRule() == null) {
            throw new IllegalArgumentException("\u4e2a\u6027\u5316\u83dc\u5355rule\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String json = JsonMapper.nonEmptyMapper().toJson((Object)menu);
        logger.debug("create rule menu: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap map = JsonMapper.defaultMapper().json2Map(response);
        if (map.containsKey("menuid")) {
            return (String)map.get("menuid");
        }
        throw new WxRuntimeException(999, "create rule menu failed");
    }

    public void delete() {
        String url = WxEndpoint.get("url.menu.delete");
        this.wxClient.get(url);
    }

    public void delete(String menuId) {
        String url = WxEndpoint.get("url.menu.delete.condition");
        String json = String.format("{\"menuid\":\"%s\"}", menuId);
        logger.debug("delete menu: {}", (Object)menuId);
        this.wxClient.post(url, json);
    }

    public Menu get() {
        String url = WxEndpoint.get("url.menu.get");
        String content = this.wxClient.get(url);
        logger.debug("get default menu: {}", (Object)content);
        MenuWrapper menuWrapper = (MenuWrapper)JsonMapper.nonEmptyMapper().fromJson(content, MenuWrapper.class);
        return menuWrapper.getMenu();
    }

    public List<RuleMenu> getRuleMenus() {
        String url = WxEndpoint.get("url.menu.get");
        String content = this.wxClient.get(url);
        logger.debug("get rule menus: {}", (Object)content);
        MenuWrapper menuWrapper = (MenuWrapper)JsonMapper.nonEmptyMapper().fromJson(content, MenuWrapper.class);
        return menuWrapper.getRuleMenus();
    }

    public MenuConfig getMenuConfig() {
        String url = WxEndpoint.get("url.menu.get.self");
        String content = this.wxClient.get(url);
        logger.debug("get menu config: {}", (Object)content);
        return (MenuConfig)JsonMapper.nonEmptyMapper().fromJson(content, MenuConfig.class);
    }

    public Menu match(String userId) {
        String url = WxEndpoint.get("url.menu.match");
        String request = String.format("{\"user_id\":\"%s\"}", userId);
        String response = this.wxClient.post(url, request);
        logger.debug("matched menu: {}", (Object)response);
        MenuWrapper menuWrapper = (MenuWrapper)JsonMapper.nonEmptyMapper().fromJson(response, MenuWrapper.class);
        return menuWrapper.getMenu();
    }

    public List<Menu> list() {
        String url = WxEndpoint.get("url.menu.get");
        String content = this.wxClient.get(url);
        logger.debug("lit menu: {}", (Object)content);
        MenuWrapper menuWrapper = (MenuWrapper)JsonMapper.nonEmptyMapper().fromJson(content, MenuWrapper.class);
        ArrayList<Menu> menus = new ArrayList<Menu>();
        menus.add(menuWrapper.getMenu());
        if (menuWrapper.getRuleMenus() != null && !menuWrapper.getRuleMenus().isEmpty()) {
            menus.addAll(menuWrapper.getRuleMenus());
        }
        return menus;
    }

    public static class MenuWrapper
    implements Serializable {
        private Menu menu;
        @JsonProperty(value="conditionalmenu")
        private List<RuleMenu> ruleMenus;

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            this.menu = menu;
        }

        public List<RuleMenu> getRuleMenus() {
            return this.ruleMenus;
        }

        public void setRuleMenus(List<RuleMenu> ruleMenus) {
            this.ruleMenus = ruleMenus;
        }
    }
}

