/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.media;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.media.Media;
import com.riversoft.weixin.common.media.MediaType;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Medias {
    private static Logger logger = LoggerFactory.getLogger(Medias.class);
    private WxClient wxClient;

    public static Medias defaultMedias() {
        return Medias.with(AppSetting.defaultSettings());
    }

    public static Medias with(AppSetting appSetting) {
        Medias medias = new Medias();
        medias.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return medias;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Media upload(MediaType type, InputStream inputStream, String fileName) {
        if (type == MediaType.file || type == MediaType.mpnews) {
            throw new WxRuntimeException(999, "unsupported media type: " + type.name());
        }
        String url = WxEndpoint.get("url.media.upload");
        String response = this.wxClient.post(String.format(url, type.name()), inputStream, fileName);
        logger.debug("upload media response: {}", (Object)response);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return (Media)JsonMapper.defaultMapper().fromJson(response, Media.class);
        }
        logger.warn("media upload failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public File download(String mediaId) {
        return this.wxClient.download(String.format(WxEndpoint.get("url.media.get"), mediaId));
    }
}

