/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.jsapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.decrypt.AesException;
import com.riversoft.weixin.common.decrypt.SHA1;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.jsapi.JsAPISignature;
import com.riversoft.weixin.common.jsapi.WxCardAPISignature;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsAPIs {
    private static Logger logger = LoggerFactory.getLogger(JsAPIs.class);
    private APITicket jsAPITicket;
    private APITicket wxCardAPITicket;
    private WxClient wxClient;

    public static JsAPIs defaultJsAPIs() {
        return JsAPIs.with(AppSetting.defaultSettings());
    }

    public static JsAPIs with(AppSetting appSetting) {
        JsAPIs jsAPIs = new JsAPIs();
        jsAPIs.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return jsAPIs;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    private synchronized void getJsAPITicket() {
        if (this.jsAPITicket == null || this.jsAPITicket.expired()) {
            String url = WxEndpoint.get("url.jsapi.ticket.get");
            String response = this.wxClient.get(url);
            this.jsAPITicket = APITicket.fromJson(response);
        }
    }

    private synchronized void getWxCardAPITicket() {
        if (this.wxCardAPITicket == null || this.wxCardAPITicket.expired()) {
            String url = WxEndpoint.get("url.wxcard.jsapi.ticket.get");
            String response = this.wxClient.get(url);
            this.wxCardAPITicket = APITicket.fromJson(response);
        }
    }

    public JsAPISignature createJsAPISignature(String url) {
        if (this.jsAPITicket == null || this.jsAPITicket.expired()) {
            this.getJsAPITicket();
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String ticket = this.jsAPITicket.getTicket();
        try {
            String signature = SHA1.getSHA1((String)("jsapi_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timestamp + "&url=" + url));
            JsAPISignature jsAPISignature = new JsAPISignature();
            jsAPISignature.setAppId(this.wxClient.getClientId());
            jsAPISignature.setNonce(nonce);
            jsAPISignature.setTimestamp(timestamp);
            jsAPISignature.setSignature(signature);
            jsAPISignature.setUrl(url);
            return jsAPISignature;
        }
        catch (AesException e) {
            logger.error("createJsAPISignature failed", (Throwable)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    public WxCardAPISignature createWxCardJsAPISignature(WxCardAPISignature wxCardAPISignature) {
        if (this.wxCardAPITicket == null || this.wxCardAPITicket.expired()) {
            this.getWxCardAPITicket();
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String ticket = this.wxCardAPITicket.getTicket();
        ArrayList<String> parameters = new ArrayList<String>();
        if (wxCardAPISignature.isChooseCard()) {
            parameters.add(this.wxClient.getClientId());
        }
        parameters.add(ticket);
        parameters.add(wxCardAPISignature.getCardId());
        parameters.add(nonce);
        parameters.add(String.valueOf(timestamp));
        if (wxCardAPISignature.getCardType() != null && !"".equals(wxCardAPISignature.getCardType())) {
            parameters.add(wxCardAPISignature.getCardType());
        }
        if (wxCardAPISignature.getCode() != null && !"".equals(wxCardAPISignature.getCode())) {
            parameters.add(wxCardAPISignature.getCode());
        }
        if (wxCardAPISignature.getBalance() != null && !"".equals(wxCardAPISignature.getBalance())) {
            parameters.add(wxCardAPISignature.getBalance());
        }
        if (wxCardAPISignature.getOpenId() != null && !"".equals(wxCardAPISignature.getOpenId())) {
            parameters.add(wxCardAPISignature.getOpenId());
        }
        if (wxCardAPISignature.getLocationId() != null && !"".equals(wxCardAPISignature.getLocationId())) {
            parameters.add(wxCardAPISignature.getLocationId());
        }
        try {
            String signature = SHA1.getSHA1((String[])((String[])parameters.toArray()));
            wxCardAPISignature.setNonce(nonce);
            wxCardAPISignature.setTimestamp(timestamp);
            wxCardAPISignature.setSignature(signature);
            return wxCardAPISignature;
        }
        catch (AesException e) {
            logger.error("createWxCardJsAPISignature failed", (Throwable)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    public static class APITicket {
        private String ticket;
        @JsonProperty(value="expires_in")
        private long expiresIn;
        private long expiresTill;

        public static APITicket fromJson(String json) {
            return (APITicket)JsonMapper.defaultMapper().fromJson(json, APITicket.class);
        }

        public String getTicket() {
            return this.ticket;
        }

        public void setTicket(String ticket) {
            this.ticket = ticket;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            this.expiresTill = System.currentTimeMillis() + expiresIn * 1000L - 60000L;
        }

        public long getExpiresTill() {
            return this.expiresTill;
        }

        public boolean expired() {
            return System.currentTimeMillis() > this.expiresTill;
        }
    }
}

