/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.care;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.care.Accounts;
import com.riversoft.weixin.mp.care.bean.Session;
import com.riversoft.weixin.mp.care.bean.SessionLog;
import com.riversoft.weixin.mp.care.bean.WaitingSessions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sessions {
    private static Logger logger = LoggerFactory.getLogger(Accounts.class);
    private WxClient wxClient;

    public static Sessions defaultSessions() {
        return Sessions.with(AppSetting.defaultSettings());
    }

    public static Sessions with(AppSetting appSetting) {
        Sessions sessions = new Sessions();
        sessions.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return sessions;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void create(String care, String openId, String text) {
        String url = WxEndpoint.get("url.care.session.create");
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("kf_account", care);
        request.put("openid", openId);
        if (text != null && !"".equals(text)) {
            request.put("text", text);
        }
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("create session: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void close(String care, String openId, String text) {
        String url = WxEndpoint.get("url.care.session.close");
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("kf_account", care);
        request.put("openid", openId);
        if (text != null && !"".equals(text)) {
            request.put("text", text);
        }
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("close session: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public Session get(String openId) {
        String url = WxEndpoint.get("url.care.session.get");
        String response = this.wxClient.get(String.format(url, openId));
        logger.debug("get session {} for user: {}", (Object)response, (Object)openId);
        return (Session)JsonMapper.defaultMapper().fromJson(response, Session.class);
    }

    public List<Session> getSessionsByAccount(String account) {
        String url = WxEndpoint.get("url.care.session.list.byaccount");
        String response = this.wxClient.get(String.format(url, account));
        logger.debug("list care sessions by care account :{}", (Object)response);
        SessionList sessionList = (SessionList)JsonMapper.defaultMapper().fromJson(response, SessionList.class);
        return sessionList.getSessions();
    }

    public WaitingSessions getWaitingSessions() {
        String url = WxEndpoint.get("url.care.session.listwait");
        String response = this.wxClient.get(url);
        logger.debug("list care waiting sessions :{}", (Object)response);
        WaitingSessions sessionList = (WaitingSessions)JsonMapper.defaultMapper().fromJson(response, WaitingSessions.class);
        return sessionList;
    }

    public List<SessionLog> listSessionLogs(Date start, Date end, int index, int size) {
        String url = WxEndpoint.get("url.care.session.logs");
        HashMap<String, Number> request = new HashMap<String, Number>();
        request.put("starttime", start.getTime() / 1000L);
        request.put("endtime", end.getTime() / 1000L);
        request.put("pageindex", index);
        request.put("pagesize", size);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("get session logs: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        SessionLogList sessionLogList = (SessionLogList)JsonMapper.defaultMapper().fromJson(response, SessionLogList.class);
        return sessionLogList.getLogs();
    }

    public static class SessionLogList {
        @JsonProperty(value="sessionlist")
        private List<SessionLog> logs;

        public List<SessionLog> getLogs() {
            return this.logs;
        }

        public void setLogs(List<SessionLog> logs) {
            this.logs = logs;
        }
    }

    public static class SessionList {
        @JsonProperty(value="sessionlist")
        private List<Session> sessions;

        public List<Session> getSessions() {
            return this.sessions;
        }

        public void setSessions(List<Session> sessions) {
            this.sessions = sessions;
        }
    }
}

