/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.care;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.care.bean.Account;
import com.riversoft.weixin.mp.care.bean.AccountStatus;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accounts {
    private static Logger logger = LoggerFactory.getLogger(Accounts.class);
    private WxClient wxClient;

    public static Accounts defaultAccounts() {
        return Accounts.with(AppSetting.defaultSettings());
    }

    public static Accounts with(AppSetting appSetting) {
        Accounts accounts = new Accounts();
        accounts.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return accounts;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void add(String account, String nickName, String password) {
        String url = WxEndpoint.get("url.care.account.add");
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("kf_account", account);
        request.put("nickname", nickName);
        request.put("password", password);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("add care account: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void update(String account, String nickName, String password) {
        String url = WxEndpoint.get("url.care.account.update");
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("kf_account", account);
        request.put("nickname", nickName);
        request.put("password", password);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.debug("add care account: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void delete(String account) {
        String url = WxEndpoint.get("url.care.account.delete");
        logger.debug("delete care account: {}", (Object)account);
        this.wxClient.get(String.format(url, account));
    }

    public void uploadHeadImage(String account, InputStream inputStream, String fileName) {
        String url = WxEndpoint.get("url.care.account.uploadhead");
        logger.debug("upload care account :{} head image: {}", (Object)account, (Object)fileName);
        this.wxClient.post(String.format(url, account), inputStream, fileName);
    }

    public List<Account> list() {
        String url = WxEndpoint.get("url.care.account.list");
        String response = this.wxClient.get(url);
        logger.debug("list care accounts :{}", (Object)response);
        CareListResponse careListResponse = (CareListResponse)JsonMapper.defaultMapper().fromJson(response, CareListResponse.class);
        return careListResponse.getList();
    }

    public List<AccountStatus> listStatus() {
        String url = WxEndpoint.get("url.care.account.liststatus");
        String response = this.wxClient.get(url);
        logger.debug("list care account status :{}", (Object)response);
        CareListStatusResponse careListStatusResponse = (CareListStatusResponse)JsonMapper.defaultMapper().fromJson(response, CareListStatusResponse.class);
        return careListStatusResponse.getList();
    }

    public static class CareListStatusResponse {
        @JsonProperty(value="kf_online_list")
        private List<AccountStatus> list;

        public List<AccountStatus> getList() {
            return this.list;
        }

        public void setList(List<AccountStatus> list) {
            this.list = list;
        }
    }

    public static class CareListResponse {
        @JsonProperty(value="kf_list")
        private List<Account> list;

        public List<Account> getList() {
            return this.list;
        }

        public void setList(List<Account> list) {
            this.list = list;
        }
    }
}

