/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.base;

import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSetting {
    private static Logger logger = LoggerFactory.getLogger(AppSetting.class);
    private static AppSetting appSetting = null;
    private String appId;
    private String secret;
    private String token;
    private String aesKey;
    private String tokenHolderClass;

    public AppSetting() {
    }

    public AppSetting(String appId, String secret) {
        this.appId = appId;
        this.secret = secret;
    }

    public static void setDefault(AppSetting appSetting) {
        AppSetting.appSetting = appSetting;
    }

    public static AppSetting defaultSettings() {
        if (appSetting == null) {
            AppSetting.loadFromSystemProperties();
        }
        if (appSetting == null) {
            AppSetting.loadFromClasspath();
        }
        if (appSetting == null) {
            throw new WxRuntimeException(999, "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u8bbe\u7f6e\u7f3a\u7701\u7684appId\u548csecret,\u8bf7\u4f7f\u7528setDefault\u65b9\u6cd5\u6216\u8005\u5728classpath\u4e0b\u9762\u521b\u5efawx-mp-settings.xml\u6587\u4ef6.");
        }
        return appSetting;
    }

    private static void loadFromSystemProperties() {
        if (System.getProperties().contains("mpconfig")) {
            logger.info("loading mp configuration from system properties...");
            String xml = System.getProperties().getProperty("mpconfig", "");
            logger.info("mpconfig: {}", (Object)xml);
            if (xml == null || "".equals(xml)) {
                return;
            }
            try {
                AppSetting setting;
                appSetting = setting = (AppSetting)XmlObjectMapper.defaultMapper().fromXml(xml, AppSetting.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadFromClasspath() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-mp-settings-test.xml");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-mp-settings.xml");
            }
            if (inputStream != null) {
                AppSetting setting;
                String xml = IOUtils.toString((InputStream)inputStream);
                appSetting = setting = (AppSetting)XmlObjectMapper.defaultMapper().fromXml(xml, AppSetting.class);
            }
        }
        catch (IOException e) {
            logger.error("read settings from wx-mp-settings-test.xml or wx-mp-settings.xml failed:", (Throwable)e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public String getTokenHolderClass() {
        return this.tokenHolderClass;
    }

    public void setTokenHolderClass(String tokenHolderClass) {
        this.tokenHolderClass = tokenHolderClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSetting that = (AppSetting)o;
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        return this.secret.equals(that.secret);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.secret.hashCode();
        return result;
    }
}

