/*
 * Decompiled with CFR 0.152.
 */
package cn.carbs.android.expandabletextview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import cn.carbs.android.expandabletextview.library.R;
import java.lang.reflect.Field;

public class ExpandableTextView
extends TextView {
    public static final int STATE_SHRINK = 0;
    public static final int STATE_EXPAND = 1;
    private static final String CLASS_NAME_VIEW = "android.view.View";
    private static final String CLASS_NAME_LISTENER_INFO = "android.view.View$ListenerInfo";
    private static final String ELLIPSIS_HINT = "..";
    private static final String GAP_TO_EXPAND_HINT = " ";
    private static final String GAP_TO_SHRINK_HINT = " ";
    private static final int MAX_LINES_ON_SHRINK = 2;
    private static final int TO_EXPAND_HINT_COLOR = -13330213;
    private static final int TO_SHRINK_HINT_COLOR = -1618884;
    private static final int TO_EXPAND_HINT_COLOR_BG_PRESSED = 0x55999999;
    private static final int TO_SHRINK_HINT_COLOR_BG_PRESSED = 0x55999999;
    private static final boolean TOGGLE_ENABLE = true;
    private static final boolean SHOW_TO_EXPAND_HINT = true;
    private static final boolean SHOW_TO_SHRINK_HINT = true;
    private String mEllipsisHint;
    private String mToExpandHint;
    private String mToShrinkHint;
    private String mGapToExpandHint = " ";
    private String mGapToShrinkHint = " ";
    private boolean mToggleEnable = true;
    private boolean mShowToExpandHint = true;
    private boolean mShowToShrinkHint = true;
    private int mMaxLinesOnShrink = 2;
    private int mToExpandHintColor = -13330213;
    private int mToShrinkHintColor = -1618884;
    private int mToExpandHintColorBgPressed = 0x55999999;
    private int mToShrinkHintColorBgPressed = 0x55999999;
    private int mCurrState = 0;
    private TouchableSpan mTouchableSpan;
    private TextView.BufferType mBufferType = TextView.BufferType.NORMAL;
    private TextPaint mTextPaint;
    private Layout mLayout;
    private int mTextLineCount = -1;
    private int mLayoutWidth = 0;
    private int mFutureTextViewWidth = 0;
    private CharSequence mOrigText;
    private ExpandableClickListener mExpandableClickListener;
    private OnExpandListener mOnExpandListener;

    public ExpandableTextView(Context context) {
        super(context);
        this.init();
    }

    public ExpandableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
        this.init();
    }

    public ExpandableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs);
        this.init();
    }

    private void initAttr(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandableTextView);
        if (a == null) {
            return;
        }
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.ExpandableTextView_etv_MaxLinesOnShrink) {
                this.mMaxLinesOnShrink = a.getInteger(attr, 2);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_EllipsisHint) {
                this.mEllipsisHint = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToExpandHint) {
                this.mToExpandHint = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToShrinkHint) {
                this.mToShrinkHint = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_EnableToggle) {
                this.mToggleEnable = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToExpandHintShow) {
                this.mShowToExpandHint = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToShrinkHintShow) {
                this.mShowToShrinkHint = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToExpandHintColor) {
                this.mToExpandHintColor = a.getInteger(attr, -13330213);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToShrinkHintColor) {
                this.mToShrinkHintColor = a.getInteger(attr, -1618884);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToExpandHintColorBgPressed) {
                this.mToExpandHintColorBgPressed = a.getInteger(attr, 0x55999999);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_ToShrinkHintColorBgPressed) {
                this.mToShrinkHintColorBgPressed = a.getInteger(attr, 0x55999999);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_InitState) {
                this.mCurrState = a.getInteger(attr, 0);
                continue;
            }
            if (attr == R.styleable.ExpandableTextView_etv_GapToExpandHint) {
                this.mGapToExpandHint = a.getString(attr);
                continue;
            }
            if (attr != R.styleable.ExpandableTextView_etv_GapToShrinkHint) continue;
            this.mGapToShrinkHint = a.getString(attr);
        }
        a.recycle();
    }

    private void init() {
        this.mTouchableSpan = new TouchableSpan();
        this.setMovementMethod((MovementMethod)new LinkTouchMovementMethod());
        if (TextUtils.isEmpty((CharSequence)this.mEllipsisHint)) {
            this.mEllipsisHint = ELLIPSIS_HINT;
        }
        if (TextUtils.isEmpty((CharSequence)this.mToExpandHint)) {
            this.mToExpandHint = this.getResources().getString(R.string.to_expand_hint);
        }
        if (TextUtils.isEmpty((CharSequence)this.mToShrinkHint)) {
            this.mToShrinkHint = this.getResources().getString(R.string.to_shrink_hint);
        }
        if (this.mToggleEnable) {
            this.mExpandableClickListener = new ExpandableClickListener();
            this.setOnClickListener(this.mExpandableClickListener);
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewTreeObserver obs = ExpandableTextView.this.getViewTreeObserver();
                if (Build.VERSION.SDK_INT >= 16) {
                    obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                ExpandableTextView.this.setTextInternal(ExpandableTextView.this.getNewTextByConfig(), ExpandableTextView.this.mBufferType);
            }
        });
    }

    public void updateForRecyclerView(CharSequence text, int futureTextViewWidth, int expandState) {
        this.mFutureTextViewWidth = futureTextViewWidth;
        this.mCurrState = expandState;
        this.setText(text);
    }

    public void updateForRecyclerView(CharSequence text, TextView.BufferType type, int futureTextViewWidth) {
        this.mFutureTextViewWidth = futureTextViewWidth;
        this.setText(text, type);
    }

    public void updateForRecyclerView(CharSequence text, int futureTextViewWidth) {
        this.mFutureTextViewWidth = futureTextViewWidth;
        this.setText(text);
    }

    public int getExpandState() {
        return this.mCurrState;
    }

    private CharSequence getNewTextByConfig() {
        if (TextUtils.isEmpty((CharSequence)this.mOrigText)) {
            return this.mOrigText;
        }
        this.mLayout = this.getLayout();
        if (this.mLayout != null) {
            this.mLayoutWidth = this.mLayout.getWidth();
        }
        if (this.mLayoutWidth <= 0) {
            if (this.getWidth() == 0) {
                if (this.mFutureTextViewWidth == 0) {
                    return this.mOrigText;
                }
                this.mLayoutWidth = this.mFutureTextViewWidth - this.getPaddingLeft() - this.getPaddingRight();
            } else {
                this.mLayoutWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            }
        }
        this.mTextPaint = this.getPaint();
        this.mTextLineCount = -1;
        switch (this.mCurrState) {
            case 0: {
                int extraWidth;
                int extraOffset;
                this.mLayout = new DynamicLayout(this.mOrigText, this.mTextPaint, this.mLayoutWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                this.mTextLineCount = this.mLayout.getLineCount();
                if (this.mTextLineCount <= this.mMaxLinesOnShrink) {
                    return this.mOrigText;
                }
                int indexEnd = this.getValidLayout().getLineEnd(this.mMaxLinesOnShrink - 1);
                int indexStart = this.getValidLayout().getLineStart(this.mMaxLinesOnShrink - 1);
                int indexEndTrimmed = indexEnd - this.getLengthOfString(this.mEllipsisHint) - (this.mShowToExpandHint ? this.getLengthOfString(this.mToExpandHint) + this.getLengthOfString(this.mGapToExpandHint) : 0);
                if (indexEndTrimmed <= indexStart) {
                    indexEndTrimmed = indexEnd;
                }
                int remainWidth = this.getValidLayout().getWidth() - (int)((double)this.mTextPaint.measureText(this.mOrigText.subSequence(indexStart, indexEndTrimmed).toString()) + 0.5);
                float widthTailReplaced = this.mTextPaint.measureText(this.getContentOfString(this.mEllipsisHint) + (this.mShowToExpandHint ? this.getContentOfString(this.mToExpandHint) + this.getContentOfString(this.mGapToExpandHint) : ""));
                int indexEndTrimmedRevised = indexEndTrimmed;
                if ((float)remainWidth > widthTailReplaced) {
                    extraOffset = 0;
                    extraWidth = 0;
                    while ((float)remainWidth > widthTailReplaced + (float)extraWidth && indexEndTrimmed + ++extraOffset <= this.mOrigText.length()) {
                        extraWidth = (int)((double)this.mTextPaint.measureText(this.mOrigText.subSequence(indexEndTrimmed, indexEndTrimmed + extraOffset).toString()) + 0.5);
                    }
                    indexEndTrimmedRevised += extraOffset - 1;
                } else {
                    extraOffset = 0;
                    extraWidth = 0;
                    while ((float)(remainWidth + extraWidth) < widthTailReplaced && indexEndTrimmed + --extraOffset > indexStart) {
                        extraWidth = (int)((double)this.mTextPaint.measureText(this.mOrigText.subSequence(indexEndTrimmed + extraOffset, indexEndTrimmed).toString()) + 0.5);
                    }
                    indexEndTrimmedRevised += extraOffset;
                }
                String fixText = this.removeEndLineBreak(this.mOrigText.subSequence(0, indexEndTrimmedRevised));
                SpannableStringBuilder ssbShrink = new SpannableStringBuilder((CharSequence)fixText).append((CharSequence)this.mEllipsisHint);
                if (this.mShowToExpandHint) {
                    ssbShrink.append((CharSequence)(this.getContentOfString(this.mGapToExpandHint) + this.getContentOfString(this.mToExpandHint)));
                    ssbShrink.setSpan((Object)this.mTouchableSpan, ssbShrink.length() - this.getLengthOfString(this.mToExpandHint), ssbShrink.length(), 33);
                }
                return ssbShrink;
            }
            case 1: {
                if (!this.mShowToShrinkHint) {
                    return this.mOrigText;
                }
                this.mLayout = new DynamicLayout(this.mOrigText, this.mTextPaint, this.mLayoutWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                this.mTextLineCount = this.mLayout.getLineCount();
                if (this.mTextLineCount <= this.mMaxLinesOnShrink) {
                    return this.mOrigText;
                }
                SpannableStringBuilder ssbExpand = new SpannableStringBuilder(this.mOrigText).append((CharSequence)this.mGapToShrinkHint).append((CharSequence)this.mToShrinkHint);
                ssbExpand.setSpan((Object)this.mTouchableSpan, ssbExpand.length() - this.getLengthOfString(this.mToShrinkHint), ssbExpand.length(), 33);
                return ssbExpand;
            }
        }
        return this.mOrigText;
    }

    private String removeEndLineBreak(CharSequence text) {
        String str = text.toString();
        while (str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public void setExpandListener(OnExpandListener listener) {
        this.mOnExpandListener = listener;
    }

    private Layout getValidLayout() {
        return this.mLayout != null ? this.mLayout : this.getLayout();
    }

    private void toggle() {
        switch (this.mCurrState) {
            case 0: {
                this.mCurrState = 1;
                if (this.mOnExpandListener == null) break;
                this.mOnExpandListener.onExpand(this);
                break;
            }
            case 1: {
                this.mCurrState = 0;
                if (this.mOnExpandListener == null) break;
                this.mOnExpandListener.onShrink(this);
            }
        }
        this.setTextInternal(this.getNewTextByConfig(), this.mBufferType);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.mOrigText = text;
        this.mBufferType = type;
        this.setTextInternal(this.getNewTextByConfig(), type);
    }

    private void setTextInternal(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
    }

    private int getLengthOfString(String string2) {
        if (string2 == null) {
            return 0;
        }
        return string2.length();
    }

    private String getContentOfString(String string2) {
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public View.OnClickListener getOnClickListener(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            return this.getOnClickListenerV14(view);
        }
        return this.getOnClickListenerV(view);
    }

    private View.OnClickListener getOnClickListenerV(View view) {
        View.OnClickListener retrievedListener = null;
        try {
            Field field = Class.forName(CLASS_NAME_VIEW).getDeclaredField("mOnClickListener");
            field.setAccessible(true);
            retrievedListener = (View.OnClickListener)field.get(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retrievedListener;
    }

    private View.OnClickListener getOnClickListenerV14(View view) {
        View.OnClickListener retrievedListener = null;
        try {
            Field clickListenerField;
            Field listenerField = Class.forName(CLASS_NAME_VIEW).getDeclaredField("mListenerInfo");
            Object listenerInfo = null;
            if (listenerField != null) {
                listenerField.setAccessible(true);
                listenerInfo = listenerField.get(view);
            }
            if ((clickListenerField = Class.forName(CLASS_NAME_LISTENER_INFO).getDeclaredField("mOnClickListener")) != null && listenerInfo != null) {
                clickListenerField.setAccessible(true);
                retrievedListener = (View.OnClickListener)clickListenerField.get(listenerInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retrievedListener;
    }

    public class LinkTouchMovementMethod
    extends LinkMovementMethod {
        private TouchableSpan mPressedSpan;

        public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent event) {
            if (event.getAction() == 0) {
                this.mPressedSpan = this.getPressedSpan(textView, spannable, event);
                if (this.mPressedSpan != null) {
                    this.mPressedSpan.setPressed(true);
                    Selection.setSelection((Spannable)spannable, (int)spannable.getSpanStart((Object)this.mPressedSpan), (int)spannable.getSpanEnd((Object)this.mPressedSpan));
                }
            } else if (event.getAction() == 2) {
                TouchableSpan touchedSpan = this.getPressedSpan(textView, spannable, event);
                if (this.mPressedSpan != null && touchedSpan != this.mPressedSpan) {
                    this.mPressedSpan.setPressed(false);
                    this.mPressedSpan = null;
                    Selection.removeSelection((Spannable)spannable);
                }
            } else {
                if (this.mPressedSpan != null) {
                    this.mPressedSpan.setPressed(false);
                    super.onTouchEvent(textView, spannable, event);
                }
                this.mPressedSpan = null;
                Selection.removeSelection((Spannable)spannable);
            }
            return true;
        }

        private TouchableSpan getPressedSpan(TextView textView, Spannable spannable, MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= textView.getTotalPaddingLeft();
            y -= textView.getTotalPaddingTop();
            Layout layout = textView.getLayout();
            int line = layout.getLineForVertical(y += textView.getScrollY());
            int off = layout.getOffsetForHorizontal(line, (float)(x += textView.getScrollX()));
            TouchableSpan[] link = (TouchableSpan[])spannable.getSpans(off, off, TouchableSpan.class);
            TouchableSpan touchedSpan = null;
            if (link.length > 0) {
                touchedSpan = link[0];
            }
            return touchedSpan;
        }
    }

    private class TouchableSpan
    extends ClickableSpan {
        private boolean mIsPressed;

        private TouchableSpan() {
        }

        public void setPressed(boolean isSelected) {
            this.mIsPressed = isSelected;
        }

        public void onClick(View widget) {
            if (!ExpandableTextView.this.hasOnClickListeners() || !(ExpandableTextView.this.getOnClickListener((View)ExpandableTextView.this) instanceof ExpandableClickListener)) {
                ExpandableTextView.this.toggle();
            }
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            switch (ExpandableTextView.this.mCurrState) {
                case 0: {
                    ds.setColor(ExpandableTextView.this.mToExpandHintColor);
                    ds.bgColor = this.mIsPressed ? ExpandableTextView.this.mToExpandHintColorBgPressed : 0;
                    break;
                }
                case 1: {
                    ds.setColor(ExpandableTextView.this.mToShrinkHintColor);
                    ds.bgColor = this.mIsPressed ? ExpandableTextView.this.mToShrinkHintColorBgPressed : 0;
                }
            }
            ds.setUnderlineText(false);
        }
    }

    private class ExpandableClickListener
    implements View.OnClickListener {
        private ExpandableClickListener() {
        }

        public void onClick(View view) {
            ExpandableTextView.this.toggle();
        }
    }

    public static interface OnExpandListener {
        public void onExpand(ExpandableTextView var1);

        public void onShrink(ExpandableTextView var1);
    }
}

