/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.web.service.impl;

import club.gclmit.gear4j.core.utils.SecureUtils;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.CosClient;
import club.gclmit.gear4j.web.mapper.CosFileMapper;
import club.gclmit.gear4j.web.service.DefaultCosFileService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="defaultFileService")
public class DefaultCosFileServiceImpl
extends ServiceImpl<CosFileMapper, FileInfo>
implements DefaultCosFileService {
    @Autowired
    private CosFileMapper cosFileMapper;
    @Autowired(required=false)
    private CosClient cosClient;

    @Override
    public FileInfo uploadFile(MultipartFile file) {
        String md5 = SecureUtils.md5((MultipartFile)file);
        FileInfo fileInfo = this.queryMd5(md5);
        if (fileInfo == null && StringUtils.isNotBlank((CharSequence)(fileInfo = this.cosClient.upload(file)).getUrl())) {
            this.save(fileInfo);
        }
        return fileInfo;
    }

    @Override
    public FileInfo queryMd5(String md5) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FileInfo::getMd5, (Object)md5);
        return (FileInfo)this.cosFileMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public FileInfo queryKey(String key) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FileInfo::getOssKey, (Object)key);
        return (FileInfo)this.cosFileMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<FileInfo> linkQueryKey(String key) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(FileInfo::getOssKey, (Object)key);
        return this.cosFileMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FileInfo> linkQueryFileName(String fileName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(FileInfo::getName, (Object)fileName);
        return this.cosFileMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FileInfo> queryFileSizeBetween(Long startSize, Long endSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().between(FileInfo::getSize, (Object)startSize, (Object)endSize);
        return this.cosFileMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void deleteFileById(String id) {
        FileInfo info = (FileInfo)this.getById((Serializable)((Object)id));
        this.cosClient.delete(info.getOssKey());
    }

    @Override
    public void deleteFile(String key) {
        this.removeById(this.queryKey(key).getId());
        this.cosClient.delete(key);
    }

    @Override
    public void batchDeleteFile(List<String> keys) {
        for (String key : keys) {
            this.deleteFile(key);
        }
    }
}

