/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.web;

import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.core.utils.UrlUtils;
import club.gclmit.gear4j.domain.query.BaseQuery;
import club.gclmit.gear4j.domain.result.ApiResult;
import club.gclmit.gear4j.domain.result.PageResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class RestApiController<Service extends IService<T>, T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected Service service;

    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e", notes="\u6dfb\u52a0\u6570\u636e")
    @Operation(summary="\u6dfb\u52a0\u6570\u636e")
    @PostMapping
    public ApiResult<T> create(@Valid @RequestBody T t) {
        Assert.notNull(t, (String)"\u6dfb\u52a0\u7684\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a");
        this.log.info("\u6dfb\u52a0\u64cd\u4f5c\u6570\u636e:[{}]", (Object)StringUtils.toString(t));
        return this.service.save(t) ? ApiResult.ok() : ApiResult.fail("\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u5931\u8d25");
    }

    @GetMapping
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @Operation(summary="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PageResult<T>> list(BaseQuery baseQuery) {
        this.log.info("\u5206\u9875\u67e5\u8be2\t:[{}]", (Object)StringUtils.toString((Object)baseQuery));
        Page pages = (Page)this.service.page((IPage)new Page(baseQuery.getPage().longValue(), baseQuery.getPageSize().longValue()));
        PageResult pageResult = PageResult.page(pages.getTotal(), baseQuery.getPage(), baseQuery.getPageSize(), pages.getRecords());
        return ApiResult.ok(pageResult);
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u6570\u636e\u8be6\u60c5")
    @Operation(summary="\u6839\u636eid\u67e5\u8be2\u6570\u636e\u8be6\u60c5")
    @ApiParam(name="id", required=true, example="1111")
    @GetMapping(value={"/{id:\\d+}"})
    public ApiResult<T> getInfo(@PathVariable String id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.log.info("\u6839\u636eId:[{}]\u67e5\u8be2\u6570\u636e\u8be6\u60c5", (Object)id);
        Object t = this.service.getById((Serializable)((Object)id));
        return t != null ? ApiResult.ok(t) : ApiResult.fail("\u6267\u884c\u67e5\u8be2\u8be6\u60c5\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="\u66f4\u65b0\u6570\u636e")
    @Operation(summary="\u66f4\u65b0\u6570\u636e")
    @PutMapping
    public ApiResult<T> update(@Valid @RequestBody T t) {
        Assert.notNull(t, (String)"\u6dfb\u52a0\u7684\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a");
        this.log.info("\u66f4\u65b0\u64cd\u4f5c\u6570\u636e:[{}]", (Object)StringUtils.toString(t));
        return this.service.updateById(t) ? ApiResult.ok() : ApiResult.fail("\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u6570\u636e")
    @Operation(summary="\u6839\u636eid\u5220\u9664\u6570\u636e")
    @ApiParam(name="id", required=true, example="1111")
    @DeleteMapping(value={"/{id:\\d+}"})
    public ApiResult<T> delete(@PathVariable String id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.log.info("\u5220\u9664\u64cd\u4f5c\u6570\u636eID:[{}]", (Object)id);
        return this.service.removeById((Serializable)((Object)id)) ? ApiResult.ok() : ApiResult.fail("\u6267\u884c\u5220\u9664\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/batch"})
    public ApiResult<T> batchDelete(String ids) {
        List<String> idList;
        Assert.notNull((Object)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        this.log.info("\u6279\u91cf\u5220\u9664\uff0cids:{}", (Object)ids);
        if (UrlUtils.hasUrlEncoded((String)ids)) {
            ids = UrlUtils.decode((String)ids);
        }
        return this.service.removeByIds(idList = Arrays.asList(ids.split(","))) ? ApiResult.ok() : ApiResult.fail("\u6279\u91cf\u5220\u9664\u5931\u8d25");
    }
}

