/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.web;

import club.gclmit.gear4j.domain.result.ApiResult;
import java.sql.SQLSyntaxErrorException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class Gear4jGlobalExceptionHandler {
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ApiResult<Object> handleException(HttpRequestMethodNotSupportedException e) {
        return ApiResult.fail("\u4e0d\u652f\u6301" + e.getMethod() + "\u8bf7\u6c42");
    }

    @ExceptionHandler(value={SQLSyntaxErrorException.class})
    public ApiResult<Object> notColumn(RuntimeException e) {
        e.printStackTrace();
        return ApiResult.fail("\u5217\u4e0d\u5b58\u5728\uff1a" + e.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ApiResult<Object> constraintViolationExceptionHandler(ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        List collect = constraintViolations.stream().map(o -> o.getMessage()).collect(Collectors.toList());
        return ApiResult.fail("Bad Request", collect);
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public ApiResult<Object> validationExceptionHandler(Exception exception) {
        BindingResult bindResult = null;
        if (exception instanceof BindException) {
            bindResult = ((BindException)exception).getBindingResult();
        }
        StringBuilder message = new StringBuilder();
        if (bindResult != null && bindResult.hasErrors()) {
            bindResult.getAllErrors().forEach(objectError -> message.append(objectError.getDefaultMessage()).append(","));
        } else {
            message.append("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
        }
        return ApiResult.fail(message.substring(0, message.length() - 1));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ApiResult<Object> notFount(RuntimeException e) {
        e.printStackTrace();
        return ApiResult.fail("\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ApiResult<Object> handleException(Exception e) {
        e.printStackTrace();
        return ApiResult.fail("\u670d\u52a1\u5668\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

