/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.domain.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="\u5206\u9875\u6570\u636e\u5c01\u88c5")
@ApiModel(value="\u5206\u9875\u6570\u636e\u5c01\u88c5", description="\u5206\u9875\u6570\u636e\u5c01\u88c5")
public class PageResult<T> {
    @ApiModelProperty(value="\u603b\u6570\u91cf")
    @Schema(description="\u603b\u6570\u91cf")
    private Long total;
    @ApiModelProperty(value="\u5f53\u524d\u9875\u6570")
    @Schema(description="\u5f53\u524d\u9875\u6570")
    private Long page;
    @ApiModelProperty(value="\u6bcf\u9875\u6570\u91cf")
    @Schema(description="\u6bcf\u9875\u6570\u91cf")
    private Long pageSize;
    @ApiModelProperty(value="\u5206\u9875\u6570\u636e")
    @Schema(description="\u5206\u9875\u6570\u636e")
    private List<T> records;

    public static <T> PageResult<T> page(Long total, Long page, Long pageSize, List<T> records) {
        return new PageResult<T>(total, page, pageSize, records);
    }

    public static <T> PageResult<T> list(List<T> records) {
        long size = records.size();
        return new PageResult<T>(size, 1L, size, records);
    }

    public static <T> PageResultBuilder<T> builder() {
        return new PageResultBuilder();
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public String toString() {
        return "PageResult(total=" + this.getTotal() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", records=" + this.getRecords() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$page = this.getPage();
        Long other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Long this$pageSize = this.getPageSize();
        Long other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Long $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public PageResult(Long total, Long page, Long pageSize, List<T> records) {
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
        this.records = records;
    }

    public PageResult() {
    }

    public static class PageResultBuilder<T> {
        private Long total;
        private Long page;
        private Long pageSize;
        private List<T> records;

        PageResultBuilder() {
        }

        public PageResultBuilder<T> total(Long total) {
            this.total = total;
            return this;
        }

        public PageResultBuilder<T> page(Long page) {
            this.page = page;
            return this;
        }

        public PageResultBuilder<T> pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PageResultBuilder<T> records(List<T> records) {
            this.records = records;
            return this;
        }

        public PageResult<T> build() {
            return new PageResult<T>(this.total, this.page, this.pageSize, this.records);
        }

        public String toString() {
            return "PageResult.PageResultBuilder(total=" + this.total + ", page=" + this.page + ", pageSize=" + this.pageSize + ", records=" + this.records + ")";
        }
    }
}

