/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.domain.result;

import club.gclmit.gear4j.core.utils.DateUtils;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.domain.result.ApiCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@ApiModel(value="\u901a\u7528\u6d88\u606f\u54cd\u5e94")
@Schema(description="\u901a\u7528\u6d88\u606f\u54cd\u5e94")
public class ApiResult<T> {
    @ApiModelProperty(value="\u54cd\u5e94\u72b6\u6001\u7801", required=true)
    @Schema(description="\u54cd\u5e94\u72b6\u6001\u7801", required=true)
    private Integer code;
    @ApiModelProperty(value="\u54cd\u5e94\u63d0\u793a\u6d88\u606f", required=true)
    @Schema(description="\u54cd\u5e94\u63d0\u793a\u6d88\u606f", required=true)
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u65f6\u95f4\u6233", required=true)
    @Schema(description="\u54cd\u5e94\u65f6\u95f4\u6233", required=true)
    private String timestamp = String.valueOf(DateUtils.getTime());
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    @Schema(description="\u54cd\u5e94\u6570\u636e")
    private T data;

    public ApiResult(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> ApiResult<T> result(boolean flag) {
        if (flag) {
            return ApiResult.ok();
        }
        return ApiResult.fail("");
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, T data) {
        return ApiResult.result(apiCode, null, data);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, String msg, T data) {
        String message = apiCode.getMessage();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            message = msg;
        }
        return new ApiResult<T>(apiCode.getCode(), message, data);
    }

    public static <T> ApiResult<T> ok() {
        return ApiResult.ok(null);
    }

    public static <T> ApiResult<T> ok(T data) {
        return ApiResult.result(ApiCode.OK, data);
    }

    public static <T> ApiResult<T> ok(String message, T data) {
        return ApiResult.result(ApiCode.OK, message, data);
    }

    public static <T> ApiResult<T> ok(Integer code, String message, T data) {
        return new ApiResult<T>(code, message, data);
    }

    public static <T> ApiResult<T> fail() {
        return ApiResult.fail(ApiCode.FAIL);
    }

    public static <T> ApiResult<T> fail(String message) {
        return ApiResult.result(ApiCode.FAIL, message, null);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T data) {
        if (ApiCode.OK == apiCode) {
            throw new RuntimeException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a\uff1a" + apiCode.getCode());
        }
        return ApiResult.result(apiCode, data);
    }

    public static <T> ApiResult<T> fail(Integer code, String message) {
        return new ApiResult<Object>(code, message, null);
    }

    public static <T> ApiResult<T> fail(String message, T data) {
        return new ApiResult<T>(ApiCode.FAIL.getCode(), message, data);
    }

    public static <T> ApiResult<T> fail(Integer code, String message, T data) {
        return new ApiResult<T>(code, message, data);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "ApiResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ", data=" + this.getData() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public ApiResult() {
    }
}

