/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.config;

import cn.hutool.core.lang.Console;
import java.util.stream.Stream;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class StartedEventListener
implements ApplicationListener<WebServerInitializedEvent> {
    public void onApplicationEvent(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        int localPort = event.getWebServer().getPort();
        Console.log((String)"\u670d\u52a1\u8bbf\u95ee\u94fe\u63a5\uff1ahttp://localhost:{}", (Object[])new Object[]{localPort});
        if (StartedEventListener.hasOpenApi()) {
            Console.log((String)"Swagger\u6587\u6863\uff1ahttp://localhost:{}/doc.html | http://localhost:{}/swagger-ui/index.html", (Object[])new Object[]{localPort, localPort});
        }
    }

    private static boolean hasOpenApi() {
        return Stream.of("springfox.documentation.spring.web.plugins.Docket", "io.swagger.v3.oas.models.OpenAPI").anyMatch(clazz -> ClassUtils.isPresent((String)clazz, null));
    }
}

