/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.safe.handler;

import club.gclmit.gear4j.core.lang.Log;
import club.gclmit.gear4j.core.lang.LoggerProvider;
import club.gclmit.gear4j.core.utils.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Safelist;

public class XssHandler {
    public static final HtmlSafeList WHITE_LIST = HtmlSafeList.INSTANCE;
    public static final Document.OutputSettings DEFAULT_OUTPUT_SETTINGS = new Document.OutputSettings().escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);

    private XssHandler() {
    }

    public static String clean(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        String result = Jsoup.clean((String)text, (String)"", (Safelist)WHITE_LIST, (Document.OutputSettings)DEFAULT_OUTPUT_SETTINGS);
        return Entities.unescape((String)result);
    }

    public static boolean isXssInjection(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        String result = XssHandler.clean(text);
        if (!result.equals(text)) {
            Log.info((LoggerProvider)LoggerProvider.GEAR4J, (String)"XssInjection\u63d0\u9192\u4f60\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u786e\u8ba4\uff1a[{}]", (Object[])new Object[]{StringUtils.trimAll((String)text)});
            return true;
        }
        return false;
    }

    public static class HtmlSafeList
    extends Safelist {
        public static final HtmlSafeList INSTANCE = new HtmlSafeList();

        public HtmlSafeList() {
            this.addTags(new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "span", "embed", "object", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul"});
            this.addAttributes("a", new String[]{"href", "title", "target"});
            this.addAttributes("blockquote", new String[]{"cite"});
            this.addAttributes("col", new String[]{"span"});
            this.addAttributes("colgroup", new String[]{"span"});
            this.addAttributes("img", new String[]{"align", "alt", "src", "title"});
            this.addAttributes("ol", new String[]{"start"});
            this.addAttributes("q", new String[]{"cite"});
            this.addAttributes("table", new String[]{"summary"});
            this.addAttributes("td", new String[]{"abbr", "axis", "colspan", "rowspan", "width"});
            this.addAttributes("th", new String[]{"abbr", "axis", "colspan", "rowspan", "scope", "width"});
            this.addAttributes("video", new String[]{"src", "autoplay", "controls", "loop", "muted", "poster", "preload"});
            this.addAttributes("object", new String[]{"width", "height", "classid", "codebase"});
            this.addAttributes("param", new String[]{"name", "value"});
            this.addAttributes("embed", new String[]{"src", "quality", "width", "height", "allowFullScreen", "allowScriptAccess", "flashvars", "name", "type", "pluginspage"});
            this.addAttributes(":all", new String[]{"class", "style", "height", "width", "type", "id", "name"});
            this.addProtocols("blockquote", "cite", new String[]{"http", "https"});
            this.addProtocols("cite", "cite", new String[]{"http", "https"});
            this.addProtocols("q", "cite", new String[]{"http", "https"});
        }

        protected boolean isSafeAttribute(String tagName, Element el, Attribute attr) {
            String value;
            if (("src".equalsIgnoreCase(attr.getKey()) || "href".equalsIgnoreCase(attr.getKey())) && StringUtils.isNotBlank((CharSequence)(value = attr.getValue())) && value.toLowerCase().startsWith("javascript")) {
                return false;
            }
            if ("img".equals(tagName) && "src".equals(attr.getKey()) && attr.getValue().startsWith("data:;base64")) {
                return true;
            }
            return super.isSafeAttribute(tagName, el, attr);
        }
    }
}

