/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.safe.core;

import club.gclmit.gear4j.safe.handler.SqlHandler;
import club.gclmit.gear4j.safe.handler.XssHandler;
import java.util.Collection;

public class SafeRules {
    public static boolean isInjection(String text) {
        return SafeRules.isXssInjection(text) || SafeRules.isSqlInjection(text);
    }

    public static boolean isInjection(Collection<?> params) {
        boolean flag = false;
        for (Object param : params) {
            if (!(param instanceof String) || !SafeRules.isInjection((String)param)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isXssInjection(String text) {
        return XssHandler.isXssInjection(text);
    }

    public static boolean isSqlInjection(String text) {
        return SqlHandler.isSqlInjection(text);
    }
}

