/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.safe.core;

import club.gclmit.gear4j.core.utils.ArrayUtils;
import club.gclmit.gear4j.core.utils.IoUtils;
import club.gclmit.gear4j.safe.Gear4jSafeException;
import club.gclmit.gear4j.safe.core.SafeRules;
import cn.hutool.core.util.CharsetUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.web.servlet.HandlerMapping;

public class SafeHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public SafeHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getHeader(String name) {
        return this.validaHandler(super.getHeader(name));
    }

    public String getParameter(String name) {
        return this.validaHandler(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        Object[] values = super.getParameterValues(name);
        if (ArrayUtils.isNotEmpty((Object[])values) && SafeRules.isInjection(List.of(values))) {
            throw new Gear4jSafeException("\u60a8\u6240\u8bbf\u95ee\u7684\u9875\u9762\u8bf7\u6c42\u4e2d\u6709\u8fdd\u53cd\u5b89\u5168\u89c4\u5219\u5143\u7d20\u5b58\u5728\uff0c\u62d2\u7edd\u8bbf\u95ee!");
        }
        return super.getParameterValues(name);
    }

    public Object getAttribute(String name) {
        if (HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE.equals(name)) {
            Object attribute = super.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (Objects.isNull(attribute)) {
                return attribute;
            }
            String result = JSONObject.toJSONString((Object)attribute);
            if (SafeRules.isInjection(result)) {
                throw new Gear4jSafeException("\u60a8\u6240\u8bbf\u95ee\u7684\u9875\u9762\u8bf7\u6c42\u4e2d\u6709\u8fdd\u53cd\u5b89\u5168\u89c4\u5219\u5143\u7d20\u5b58\u5728\uff0c\u62d2\u7edd\u8bbf\u95ee!");
            }
        }
        return super.getAttribute(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        String result = IoUtils.read((InputStream)super.getInputStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
        if (SafeRules.isInjection(result)) {
            throw new Gear4jSafeException("\u60a8\u6240\u8bbf\u95ee\u7684\u9875\u9762\u8bf7\u6c42\u4e2d\u6709\u8fdd\u53cd\u5b89\u5168\u89c4\u5219\u5143\u7d20\u5b58\u5728\uff0c\u62d2\u7edd\u8bbf\u95ee!");
        }
        return super.getInputStream();
    }

    private String validaHandler(String text) {
        if (SafeRules.isInjection(text)) {
            throw new Gear4jSafeException("\u60a8\u6240\u8bbf\u95ee\u7684\u9875\u9762\u8bf7\u6c42\u4e2d\u6709\u8fdd\u53cd\u5b89\u5168\u89c4\u5219\u5143\u7d20\u5b58\u5728\uff0c\u62d2\u7edd\u8bbf\u95ee!");
        }
        return text;
    }
}

