/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.safe.core;

import club.gclmit.gear4j.core.utils.UrlUtils;
import club.gclmit.gear4j.safe.config.Gear4jSafeProperties;
import club.gclmit.gear4j.safe.core.SafeHttpServletRequestWrapper;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class SafeFilter
implements Filter {
    private Gear4jSafeProperties properties;

    public void init(FilterConfig filterConfig) {
        String config = filterConfig.getInitParameter("gear4jSafeProperties");
        this.properties = (Gear4jSafeProperties)JSONObject.parseObject((String)config, Gear4jSafeProperties.class);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.isExcludeUrl(request.getServletPath())) {
            chain.doFilter(servletRequest, servletResponse);
        } else {
            SafeHttpServletRequestWrapper xssRequest = new SafeHttpServletRequestWrapper(request);
            chain.doFilter((ServletRequest)xssRequest, servletResponse);
        }
    }

    public void destroy() {
        super.destroy();
    }

    private boolean isExcludeUrl(String url) {
        List<String> excludePatterns = this.properties.getExcludes();
        return CollUtil.isNotEmpty(excludePatterns) && UrlUtils.isIgnore(excludePatterns, (String)url);
    }
}

