/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.redis.limit;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.utils.ServletUtils;
import club.gclmit.gear4j.redis.cache.RedisCache;
import club.gclmit.gear4j.redis.limit.RateLimit;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RateLimitInterceptor
implements HandlerInterceptor {
    @Lazy
    @Resource
    private RedisCache redisCache;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        RateLimit currentLimit;
        if (handler instanceof HandlerMethod && (currentLimit = (RateLimit)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(RateLimit.class)) != null) {
            int size = currentLimit.size();
            long time = currentLimit.time();
            if (time > 0L && size > 0) {
                String key = request.getContextPath() + ":" + request.getServletPath() + ":" + ServletUtils.getClientIp((HttpServletRequest)request);
                if (!this.redisCache.hasKey(key).booleanValue()) {
                    this.redisCache.cacheValue(key, 1L, time, TimeUnit.SECONDS);
                    return true;
                }
                Long redisSize = (Long)this.redisCache.getValue(key);
                long redisTime = this.redisCache.getExpire(key);
                if (redisSize >= (long)size) {
                    throw new Gear4jException("\u5f53\u524d\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                this.redisCache.cacheValue(key, redisSize + 1L, redisTime, TimeUnit.SECONDS);
            }
        }
        return true;
    }
}

