/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.redis.cache;

import club.gclmit.gear4j.core.utils.ArrayUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCache {
    private final RedisTemplate<String, Object> redisTemplate;

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public RedisCache(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setExpire(String key, Long timeout, TimeUnit unit) {
        try {
            if (timeout > 0L) {
                this.redisTemplate.expire((Object)key, timeout.longValue(), unit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public Boolean hasKey(String key) {
        try {
            return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void remove(String ... keys) {
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            this.redisTemplate.delete(List.of(keys));
        }
    }

    public Object getValue(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Boolean cacheValue(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheValue(String key, Object value, Long time, TimeUnit unit) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), unit);
            } else {
                this.cacheValue(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateValueCache(String key, Object value) {
        try {
            this.cacheValue(key, value, this.getExpire(key), TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long incrementValue(String key, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta.longValue());
    }

    public Long decrValue(String key, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta.longValue());
    }

    public Object getHash(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> getHash(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public Boolean cacheHash(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheHash(String key, Map<String, Object> map, Long time, TimeUnit unit) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.setExpire(key, time, unit);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheHash(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheHash(String key, String item, Object value, Long time, TimeUnit unit) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.setExpire(key, time, unit);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void removeHash(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public Boolean hasHashKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double incrHash(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double decrHash(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> getSet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean hasSetKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long cacheSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long cacheSet(String key, Long time, TimeUnit unit, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.setExpire(key, time, unit);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long getSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long removeSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long getListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> getList(String key, Long start, Long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start.longValue(), end.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getList(String key, Long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean cacheList(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheList(String key, Object value, Long time, TimeUnit unit) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.setExpire(key, time, unit);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheList(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean cacheList(String key, List<Object> value, Long time, TimeUnit unit) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.setExpire(key, time, unit);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean updateList(String key, Long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index.longValue(), value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long removeList(String key, Long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count.longValue(), value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void removeList(String key, Long start, Long end) {
        try {
            this.redisTemplate.opsForList().trim((Object)key, start.longValue(), end.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

