/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.extra.notify.dingtalk;

import club.gclmit.gear4j.core.utils.SecureUtils;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.extra.notify.dingtalk.DingtalkChannel;
import cn.hutool.core.util.CharsetUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejlchina.okhttps.AHttpTask;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.OkHttps;
import java.net.URLEncoder;
import org.springframework.http.HttpStatus;

public class DingtalkBot {
    public static final String SERVER_API = "https://oapi.dingtalk.com/robot/send?access_token=%s&timestamp=%s&sign=%s";
    public static final String SERVER_HOST = "https://oapi.dingtalk.com/robot/send?access_token=";
    private String webhook;
    private String secret;
    private static DingtalkBot dingtalkBot;

    public DingtalkBot() {
    }

    public DingtalkBot(String webhook, String secret) {
        this.webhook = webhook;
        this.secret = secret;
    }

    public static DingtalkBot builder(String secret, String webhook) {
        dingtalkBot = new DingtalkBot(webhook, secret);
        return dingtalkBot;
    }

    public static DingtalkBot builder() {
        dingtalkBot = new DingtalkBot();
        return dingtalkBot;
    }

    public DingtalkBot webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    public DingtalkBot secret(String secret) {
        this.secret = secret;
        return this;
    }

    public DingtalkChannel.Link link() {
        return new DingtalkChannel.Link(dingtalkBot);
    }

    public DingtalkChannel.Markdown markdown() {
        return new DingtalkChannel.Markdown(dingtalkBot);
    }

    public DingtalkChannel.Text text() {
        return new DingtalkChannel.Text(dingtalkBot);
    }

    public DingtalkChannel.ActionCard actionCard() {
        return new DingtalkChannel.ActionCard(dingtalkBot);
    }

    public boolean send(String content) {
        long millis = System.currentTimeMillis();
        String accessToken = this.webhook.replace(SERVER_HOST, "");
        String url = String.format(SERVER_API, accessToken, millis, DingtalkBot.getSign(millis, this.secret));
        HttpResult result = ((AHttpTask)((AHttpTask)OkHttps.async((String)url).setBodyPara((Object)content)).bodyType("json")).post().getResult();
        String body = result.getBody().toString();
        System.out.println(StringUtils.format((CharSequence)"\u9489\u9489\u6d88\u606f\u53d1\u9001({}): -->{}", (Object[])new Object[]{result.getStatus(), body}));
        if (HttpStatus.OK.value() == result.getStatus()) {
            return 0 == JSONObject.parseObject((String)body).getInteger("errcode");
        }
        return false;
    }

    public static String getSign(Long timestamp, String secret) {
        String stringToSign = timestamp + "\n" + secret;
        String base64 = SecureUtils.hmacSha256((String)secret).digestBase64(stringToSign, false);
        return URLEncoder.encode(base64, CharsetUtil.CHARSET_UTF_8);
    }
}

