/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider.impl;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.AbstractCosClient;
import club.gclmit.gear4j.cos.provider.CosClient;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.ucloud.ufile.UfileClient;
import cn.ucloud.ufile.api.object.ObjectApiBuilder;
import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.auth.UfileObjectLocalAuthorization;
import cn.ucloud.ufile.bean.PutObjectResultBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcloudCosClient
extends AbstractCosClient
implements CosClient {
    private static final Logger log = LoggerFactory.getLogger(UcloudCosClient.class);
    private final ObjectApiBuilder ossClient;
    private final CosProvider cosProvider;

    public UcloudCosClient(CosProvider cosProvider) {
        super(cosProvider);
        this.cosProvider = cosProvider;
        this.ossClient = this.build(cosProvider.getAccessKeyId(), cosProvider.getAccessKeySecret(), cosProvider.getRegion(), cosProvider.getEndpoint());
    }

    @Override
    public void batchDelete(List<String> keys) {
        Assert.notEmpty(keys, (String)"[Ufile]\u6279\u91cf\u5220\u9664\u6587\u4ef6\u7684 keys \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String key : keys) {
            this.delete(key);
        }
    }

    @Override
    public void delete(String key) {
        Assert.notBlank((CharSequence)key, (String)"[Ufile]\u5220\u9664\u6587\u4ef6\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            this.ossClient.deleteObject(key, this.cosProvider.getBucket()).execute();
        }
        catch (UfileClientException e) {
            throw new Gear4jException("\u5220\u9664\u5931\u8d25,Ufile\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        catch (UfileServerException e) {
            throw new Gear4jException("\u5220\u9664\u5931\u8d25,Ufile\u670d\u52a1\u5668\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public FileInfo upload(InputStream inputStream, FileInfo fileInfo) {
        Assert.notNull((Object)inputStream, (String)"[Ufile]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 inputStream \u662f\u5426\u6b63\u5e38", (Object[])new Object[0]);
        String key = fileInfo.getOssKey();
        String url = null;
        try {
            PutObjectResultBean putObjectResultBean = (PutObjectResultBean)this.ossClient.putObject(inputStream, (long)inputStream.available(), fileInfo.getContentType()).nameAs(fileInfo.getOssKey()).toBucket(this.cosProvider.getBucket()).withStorageType("STANDARD").execute();
        }
        catch (UfileClientException e) {
            throw new Gear4jException("\u4e0a\u4f20\u5931\u8d25,Ufile\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        catch (UfileServerException | IOException e) {
            throw new Gear4jException("\u4e0a\u4f20\u5931\u8d25,Ufile\u670d\u52a1\u5668\u53d1\u751f\u5f02\u5e38", e);
        }
        if (key != null) {
            StringBuilder path = new StringBuilder();
            path.append(this.cosProvider.getProtocol()).append("://").append(this.cosProvider.getBucket()).append(".").append(this.cosProvider.getRegion()).append(".").append(this.cosProvider.getEndpoint()).append("/").append(key);
            if (StringUtils.isNotBlank((CharSequence)this.cosProvider.getStyleName())) {
                path.append(this.cosProvider.getStyleName());
            }
            url = path.toString();
        }
        fileInfo.setUrl(url);
        fileInfo.setUploadTime(DateUtil.current());
        return fileInfo;
    }

    public ObjectApiBuilder build(String secretId, String secretKey, String region, String endpoint) {
        UfileObjectLocalAuthorization auth = new UfileObjectLocalAuthorization(secretId, secretKey);
        ObjectConfig config = new ObjectConfig(region, endpoint);
        ThreadPoolExecutor executorService = ExecutorBuilder.create().setCorePoolSize(5).setMaxPoolSize(50).setWorkQueue(new LinkedBlockingQueue(100)).build();
        UfileClient.configure((UfileClient.Config)new UfileClient.Config(new HttpClient.Config(10, 5L, TimeUnit.MINUTES).setTimeout(10000L, 30000L, 30000L).setExecutorService((ExecutorService)executorService)));
        return UfileClient.object((ObjectAuthorizer)auth, (ObjectConfig)config);
    }
}

