/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider.impl;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.AbstractCosClient;
import club.gclmit.gear4j.cos.provider.CosClient;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ExecutorBuilder;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class QcloudCosClient
extends AbstractCosClient
implements CosClient {
    private static final Logger log = LoggerFactory.getLogger(QcloudCosClient.class);
    private final COSClient cosClient;
    private final CosProvider cosProvider;

    public QcloudCosClient(CosProvider cosProvider) {
        super(cosProvider);
        this.cosProvider = cosProvider;
        this.cosClient = this.build(cosProvider.getAccessKeyId(), cosProvider.getAccessKeySecret(), cosProvider.getRegion());
    }

    @Override
    public void batchDelete(List<String> keys) {
        Assert.notEmpty(keys, (String)"[\u817e\u8baf\u4e91OSS]\u6279\u91cf\u5220\u9664\u6587\u4ef6\u7684 keys \u4e0d\u80fd\u4e3a\u7a7a");
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.cosProvider.getBucket());
        ArrayList<DeleteObjectsRequest.KeyVersion> keyList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (String key : keys) {
            keyList.add(new DeleteObjectsRequest.KeyVersion(key));
        }
        deleteObjectsRequest.setKeys(keyList);
        try {
            this.cosClient.deleteObjects(deleteObjectsRequest);
        }
        catch (MultiObjectDeleteException e) {
            List errors = e.getErrors();
            throw new Gear4jException("[\u817e\u8baf\u4e91OSS]\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff08\u90e8\u5206\u6210\u529f\u90e8\u5206\u5931\u8d25\uff09" + errors.toString());
        }
        catch (CosServiceException e) {
            throw new Gear4jException("[\u817e\u8baf\u4e91OSS]\u5176\u4ed6\u9519\u8bef\uff0c\u4f8b\u5982\u53c2\u6570\u9519\u8bef\uff0c \u8eab\u4efd\u9a8c\u8bc1\u4e0d\u8fc7");
        }
        catch (CosClientException e) {
            throw new Gear4jException("[\u817e\u8baf\u4e91OSS]\u5ba2\u6237\u7aef\u9519\u8bef\uff0c\u4f8b\u5982\u8fde\u63a5\u4e0d\u4e0aCOS");
        }
    }

    @Override
    public void delete(String key) {
        Assert.hasLength((String)key, (String)"[\u817e\u8baf\u4e91OSS]\u5220\u9664\u6587\u4ef6\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        this.cosClient.deleteObject(this.cosProvider.getBucket(), key);
    }

    @Override
    public FileInfo upload(InputStream inputStream, FileInfo fileInfo) {
        Assert.notNull((Object)inputStream, (String)"[\u817e\u8baf\u4e91OSS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 inputStream \u662f\u5426\u6b63\u5e38");
        String key = fileInfo.getOssKey();
        String url = null;
        ThreadPoolExecutor executorService = ExecutorBuilder.create().setCorePoolSize(5).setMaxPoolSize(50).setWorkQueue(new LinkedBlockingQueue(100)).build();
        TransferManager transferManager = new TransferManager((COS)this.cosClient, (ExecutorService)executorService);
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.cosProvider.getBucket(), key, inputStream, objectMetadata);
            Upload upload = transferManager.upload(putObjectRequest);
            upload.waitForUploadResult();
        }
        catch (Exception e) {
            throw new Gear4jException("[\u817e\u8baf\u4e91OSS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
        finally {
            transferManager.shutdownNow();
            this.cosClient.shutdown();
        }
        if (key != null) {
            StringBuilder path = new StringBuilder();
            path.append(this.cosProvider.getProtocol()).append("://").append(this.cosProvider.getBucket()).append(".cos.").append(this.cosProvider.getRegion()).append(".myqcloud.com").append("/").append(key);
            if (StringUtils.isNotBlank((CharSequence)this.cosProvider.getStyleName())) {
                path.append(this.cosProvider.getStyleName());
            }
            url = path.toString();
        }
        fileInfo.setUrl(url);
        fileInfo.setUploadTime(DateUtil.current());
        return fileInfo;
    }

    public COSClient build(String secretId, String secretKey, String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region cosRegion = new Region(region);
        ClientConfig clientConfig = new ClientConfig(cosRegion);
        return new COSClient((COSCredentials)cred, clientConfig);
    }
}

