/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider.impl;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.AbstractCosClient;
import club.gclmit.gear4j.cos.provider.CosClient;
import cn.hutool.core.date.DateUtil;
import com.obs.services.ObsClient;
import com.obs.services.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HuaweiCosClient
extends AbstractCosClient
implements CosClient {
    private static final Logger log = LoggerFactory.getLogger(HuaweiCosClient.class);
    private final ObsClient obsClient;
    private final CosProvider cosProvider;

    public HuaweiCosClient(CosProvider cosProvider) {
        super(cosProvider);
        this.cosProvider = cosProvider;
        this.obsClient = new ObsClient(cosProvider.getAccessKeyId(), cosProvider.getAccessKeySecret(), cosProvider.getEndpoint());
    }

    @Override
    public void batchDelete(List<String> keys) {
        Assert.notEmpty(keys, (String)"[\u534e\u4e3a\u4e91OBS]\u6279\u91cf\u5220\u9664\u6587\u4ef6\u7684 keys \u4e0d\u80fd\u4e3a\u7a7a");
        for (String key : keys) {
            this.delete(key);
        }
    }

    @Override
    public void delete(String key) {
        Assert.hasLength((String)key, (String)"[\u534e\u4e3a\u4e91OBS]\u5220\u9664\u6587\u4ef6\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        this.obsClient.deleteObject(this.cosProvider.getBucket(), key);
    }

    @Override
    public FileInfo upload(InputStream inputStream, FileInfo fileInfo) {
        Assert.notNull((Object)inputStream, (String)"[\u534e\u4e3a\u4e91OBS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 inputStream \u662f\u5426\u6b63\u5e38");
        String key = fileInfo.getOssKey();
        String url = null;
        try {
            PutObjectResult putObject = this.obsClient.putObject(this.cosProvider.getBucket(), key, inputStream);
            String bucketName = putObject.getBucketName();
            log.debug("{} ->{}:\u4e0a\u4f20\u6210\u529f", (Object)bucketName, (Object)fileInfo.getOssKey());
        }
        catch (Exception e) {
            throw new Gear4jException("[\u534e\u4e3a\u4e91OBS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
        if (key != null) {
            StringBuilder path = new StringBuilder();
            path.append(this.cosProvider.getProtocol()).append("://").append(this.cosProvider.getBucket()).append(".").append(this.cosProvider.getEndpoint()).append("/").append(key);
            if (StringUtils.isNotBlank((CharSequence)this.cosProvider.getStyleName())) {
                path.append(this.cosProvider.getStyleName());
            }
            url = path.toString();
        }
        fileInfo.setUrl(url);
        fileInfo.setUploadTime(DateUtil.current());
        return fileInfo;
    }
}

