/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider.impl;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.http.HttpClient;
import club.gclmit.gear4j.core.utils.IoUtils;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.AbstractCosClient;
import club.gclmit.gear4j.cos.provider.CosClient;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejlchina.okhttps.AHttpTask;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.OkHttps;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GoFastdfsCosClient
extends AbstractCosClient
implements CosClient {
    private static final Logger log = LoggerFactory.getLogger(GoFastdfsCosClient.class);
    private final String serverUrl;

    public GoFastdfsCosClient(CosProvider cosProvider) {
        super(cosProvider);
        this.serverUrl = cosProvider.getEndpoint() + "/" + cosProvider.getBucket() + "/";
    }

    @Override
    public void batchDelete(List<String> keys) {
        Assert.notEmpty(keys, (String)"[FastDFS]\u6279\u91cf\u5220\u9664\u6587\u4ef6\u7684 keys \u4e0d\u80fd\u4e3a\u7a7a");
        for (String key : keys) {
            this.delete(key);
        }
    }

    @Override
    public void delete(String key) {
        Assert.hasLength((String)key, (String)"[FastDFS]\u5220\u9664\u6587\u4ef6\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.serverUrl + "delete?path=" + key;
        String result = ((AHttpTask)OkHttps.async((String)url).addHeader(HttpClient.header())).get().getResult().getBody().toString();
        log.info("\u5f53\u524d\u5220\u9664\u72b6\u6001:[{}]", (Object)result);
    }

    @Override
    public FileInfo upload(InputStream inputStream, FileInfo fileInfo) {
        Assert.notNull((Object)inputStream, (String)"[FastDFS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 inputStream \u662f\u5426\u6b63\u5e38");
        LocalDate localDate = LocalDate.now(ZoneId.systemDefault());
        String dateFormat = localDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        String url = null;
        try {
            String body;
            JSONObject mapper;
            String uploadUrl = this.serverUrl + "upload";
            HashMap<String, String> params = new HashMap<String, String>(6);
            params.put("path", dateFormat);
            params.put("scene", "default");
            params.put("output", "json2");
            String fileName = fileInfo.getOssKey().replace(dateFormat + "/", "");
            HttpResult result = ((AHttpTask)((AHttpTask)((AHttpTask)OkHttps.async((String)uploadUrl).addHeader(HttpClient.header())).addBodyPara(params)).addFilePara("file", fileInfo.getContentType(), fileName, IoUtils.readBytes((InputStream)inputStream))).post().getResult();
            if (result.isSuccessful() && (mapper = JSONObject.parseObject((String)(body = StringUtils.trimAll((String)result.getBody().cache().toString())))).containsKey((Object)"data")) {
                mapper = mapper.getJSONObject("data");
                url = mapper.getString("domain") + mapper.getString("path");
                fileInfo.setOssKey(mapper.getString("path"));
            }
        }
        catch (Exception e) {
            throw new Gear4jException("[FastDFS]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
        fileInfo.setUrl(url);
        fileInfo.setUploadTime(DateUtil.current());
        return fileInfo;
    }
}

