/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.CosProviderType;
import club.gclmit.gear4j.cos.provider.CosClient;
import club.gclmit.gear4j.cos.provider.impl.AliyunCosClient;
import club.gclmit.gear4j.cos.provider.impl.GoFastdfsCosClient;
import club.gclmit.gear4j.cos.provider.impl.HuaweiCosClient;
import club.gclmit.gear4j.cos.provider.impl.QcloudCosClient;
import club.gclmit.gear4j.cos.provider.impl.QiniuCosClient;
import club.gclmit.gear4j.cos.provider.impl.UcloudCosClient;
import club.gclmit.gear4j.cos.provider.impl.UpyunCosClient;

public class CosClientBuilder {
    public static CosProvider.CosProviderBuilder provider() {
        return CosProvider.builder();
    }

    public static CosClient getClient(CosProvider provider) {
        if (CosProviderType.ALIYUN.getCode().equals(provider.getProvider())) {
            return new AliyunCosClient(provider);
        }
        if (CosProviderType.GO_FASTDFS.getCode().equals(provider.getProvider())) {
            return new GoFastdfsCosClient(provider);
        }
        if (CosProviderType.HUAWEI.getCode().equals(provider.getProvider())) {
            return new HuaweiCosClient(provider);
        }
        if (CosProviderType.QCLOUD.getCode().equals(provider.getProvider())) {
            return new QcloudCosClient(provider);
        }
        if (CosProviderType.QINIU.getCode().equals(provider.getProvider())) {
            return new QiniuCosClient(provider);
        }
        if (CosProviderType.UCLOUD.getCode().equals(provider.getProvider())) {
            return new UcloudCosClient(provider);
        }
        if (CosProviderType.UPYUN.getCode().equals(provider.getProvider())) {
            return new UpyunCosClient(provider);
        }
        throw new Gear4jException("gear4j-cos: Provider\u53c2\u6570\u5f02\u5e38,\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u914d\u7f6e\u53c2\u6570");
    }
}

