/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.gear4j.cos.provider;

import club.gclmit.gear4j.core.exception.Gear4jException;
import club.gclmit.gear4j.core.utils.FileUtils;
import club.gclmit.gear4j.core.utils.IdUtils;
import club.gclmit.gear4j.core.utils.SecureUtils;
import club.gclmit.gear4j.core.utils.StringUtils;
import club.gclmit.gear4j.cos.domain.CosProvider;
import club.gclmit.gear4j.cos.domain.FileInfo;
import club.gclmit.gear4j.cos.provider.CosClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractCosClient
implements CosClient {
    protected final CosProvider cosProvider;

    public AbstractCosClient(CosProvider cosProvider) {
        this.cosProvider = cosProvider;
    }

    @Override
    public FileInfo upload(File file) {
        Assert.isTrue((boolean)file.exists(), (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.upload(fileInputStream, this.buildFileInfo(file));
        }
        catch (Exception e) {
            throw new Gear4jException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public FileInfo upload(MultipartFile file) {
        try {
            InputStream stream = file.getInputStream();
            return this.upload(stream, this.buildFileInfo(file));
        }
        catch (Exception e) {
            throw new Gear4jException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public FileInfo upload(byte[] data) {
        Assert.notEmpty(Collections.singleton(data), (String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 byte[] \u662f\u5426\u6b63\u5e38");
        String fileName = IdUtils.getYeinGid() + ".txt";
        FileInfo fileInfo = FileInfo.builder().ossKey(fileName).ossType(this.cosProvider.getProvider()).name(fileName).contentType("text/plain").size(Long.valueOf(data.length)).md5(SecureUtils.md5((byte[])data)).sha1(SecureUtils.sha1((byte[])data)).build();
        return this.upload(new ByteArrayInputStream(data), fileInfo);
    }

    @Override
    public FileInfo upload(String content) {
        return this.upload(content.getBytes(StandardCharsets.UTF_8));
    }

    public FileInfo buildFileInfo(File file) {
        String contentType = FileUtils.getMimeType((String)file.getAbsolutePath());
        String key = this.buildKey(this.cosProvider.getPrefix(), FileUtils.getSuffix((File)file));
        return FileInfo.builder().ossKey(key).ossType(this.cosProvider.getProvider()).name(file.getName()).contentType(contentType).size(file.length()).md5(SecureUtils.md5((File)file)).sha1(SecureUtils.sha1((File)file)).build();
    }

    public FileInfo buildFileInfo(MultipartFile file) {
        String key = this.buildKey(this.cosProvider.getPrefix(), FileUtils.getSuffix((MultipartFile)file));
        return FileInfo.builder().ossKey(key).ossType(this.cosProvider.getProvider()).name(file.getOriginalFilename()).contentType(file.getContentType()).size(file.getSize()).md5(SecureUtils.md5((MultipartFile)file)).sha1(SecureUtils.sha1((MultipartFile)file)).build();
    }

    public String buildKey(String prefix, String suffix) {
        LocalDate localDate = LocalDate.now();
        String dateFormat = localDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        StringBuilder path = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            path.append(prefix).append("/");
        }
        path.append(dateFormat).append("/").append(IdUtils.getYeinGid());
        if (suffix != null) {
            if (suffix.contains(".")) {
                path.append(suffix);
            } else {
                path.append(".").append(suffix);
            }
        }
        return path.toString();
    }
}

