/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public enum MethodInfoCache implements Iterable<Map.Entry<Key, MethodInfo>>
{
    INSTANCE;

    private final Map<Key, MethodInfo> cache = new HashMap<Key, MethodInfo>();

    public void put(String beanName, Class<?> clazz, Method method, ApplicationContext context) {
        MethodInfo info = new MethodInfo(clazz, context, beanName, method);
        this.cache.put(new Key(beanName, method.getName()), info);
    }

    public MethodInfo get(String beanName, String methodName) {
        return this.cache.get(new Key(beanName, methodName));
    }

    @Override
    public Iterator<Map.Entry<Key, MethodInfo>> iterator() {
        return this.cache.entrySet().iterator();
    }

    public void clear() {
        this.cache.clear();
    }

    public static final class Key {
        private final String beanName;
        private final String methodName;

        public Key(String beanName, String methodName) {
            this.beanName = beanName;
            this.methodName = methodName;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return ExtDirectSpringUtil.equal(this.beanName, other.beanName) && ExtDirectSpringUtil.equal(this.methodName, other.methodName);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.beanName, this.methodName});
        }
    }
}

