/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;

public final class ExtDirectSpringUtil {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final long secondsInAMonth = 2592000L;

    private ExtDirectSpringUtil() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public static Object invoke(ApplicationContext context, String beanName, MethodInfo methodInfo, Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object bean = context.getBean(beanName);
        Method handlerMethod = methodInfo.getMethod();
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        return handlerMethod.invoke(bean, params);
    }

    public static Object invoke(HttpServletRequest request, HttpServletResponse response, Locale locale, ApplicationContext context, ExtDirectRequest directRequest, ParametersResolver parametersResolver) throws Exception {
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
        Object[] resolvedParams = parametersResolver.resolveParameters(request, response, locale, directRequest, methodInfo);
        return ExtDirectSpringUtil.invoke(context, directRequest.getAction(), methodInfo, resolvedParams);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static void addCacheHeaders(HttpServletResponse response, String etag, Integer month) {
        Assert.notNull((Object)etag, (String)"ETag must not be null");
        long seconds = month != null ? (long)month.intValue() * 2592000L : 15552000L;
        response.setDateHeader("Expires", System.currentTimeMillis() + seconds * 1000L);
        response.setHeader("ETag", etag);
        response.setHeader("Cache-Control", "public, max-age=" + seconds);
    }

    public static void handleCacheableResponse(HttpServletRequest request, HttpServletResponse response, byte[] data, String contentType) throws IOException {
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = "\"0" + DigestUtils.md5DigestAsHex((byte[])data) + "\"";
        if (etag.equals(ifNoneMatch)) {
            response.setStatus(304);
            return;
        }
        response.setContentType(contentType);
        response.setContentLength(data.length);
        ExtDirectSpringUtil.addCacheHeaders(response, etag, 6);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }
}

