/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import ch.ralscha.extdirectspring.filter.BooleanFilter;
import ch.ralscha.extdirectspring.filter.Comparison;
import ch.ralscha.extdirectspring.filter.DateFilter;
import ch.ralscha.extdirectspring.filter.ListFilter;
import ch.ralscha.extdirectspring.filter.NumericFilter;
import ch.ralscha.extdirectspring.filter.StringFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

public class Filter {
    private final String field;

    public Filter(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public static Filter createFilter(Map<String, Object> jsonData, ConversionService conversionService) {
        String type = (String)jsonData.get("type");
        Object source = jsonData.get("value");
        if (type == null) {
            String property = (String)jsonData.get("property");
            if (property != null) {
                if (source instanceof Number) {
                    return new NumericFilter(property, (Number)source, null);
                }
                if (source instanceof Boolean) {
                    return new BooleanFilter(property, (Boolean)source);
                }
                return new StringFilter(property, source != null ? source.toString() : null);
            }
            return null;
        }
        String field = (String)jsonData.get("field");
        if (field == null) {
            field = (String)jsonData.get("property");
        }
        if (type.equals("numeric") || type.equals("int") || type.equals("float")) {
            String comparison = (String)jsonData.get("comparison");
            if (comparison == null) {
                comparison = (String)jsonData.get("operator");
            }
            Number value = (Number)conversionService.convert(source, Number.class);
            return new NumericFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("string")) {
            String value = (String)source;
            return new StringFilter(field, value);
        }
        if (type.equals("date")) {
            String comparison = (String)jsonData.get("comparison");
            if (comparison == null) {
                comparison = (String)jsonData.get("operator");
            }
            String value = (String)source;
            return new DateFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("list") || type.equals("combo")) {
            if (source instanceof String) {
                String[] values = ((String)source).split(",");
                return new ListFilter(field, Arrays.asList(values));
            }
            return new ListFilter(field, (List)source);
        }
        if (type.equals("boolean")) {
            boolean value = (Boolean)source;
            return new BooleanFilter(field, value);
        }
        return null;
    }
}

